/*
 * Decompiled with CFR 0.152.
 */
package org.xmcda.parsers.xml.xmcda_v3;

import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.xmcda.QualifiedValue;
import org.xmcda.XMCDA;
import org.xmcda.parsers.xml.xmcda_v3.Utils;
import org.xmcda.parsers.xml.xmcda_v3.XMLStreamWriter;
import org.xmcda.value.Rational;

public class RationalParser {
    public static final String RATIONAL = QualifiedValue.XMCDATypes.RATIONAL.getTag();
    public static final String NUMERATOR = "numerator";
    public static final String DENOMINATOR = "denominator";

    public Rational fromXML(XMCDA xmcda, StartElement startElement, XMLEventReader eventReader) throws XMLStreamException {
        XMLEvent event;
        Rational rational = new Rational();
        while (!(!eventReader.hasNext() || (event = eventReader.nextEvent()).isEndElement() && RATIONAL.equals(event.asEndElement().getName().getLocalPart()))) {
            if (!event.isStartElement()) continue;
            startElement = event.asStartElement();
            if (NUMERATOR.equals(startElement.getName().getLocalPart())) {
                rational.setNumerator(Integer.parseInt(Utils.getTextContent(startElement, eventReader)));
                continue;
            }
            if (!DENOMINATOR.equals(startElement.getName().getLocalPart())) continue;
            rational.setDenominator(Integer.parseInt(Utils.getTextContent(startElement, eventReader)));
        }
        return rational;
    }

    public void toXML(Rational rational, XMLStreamWriter writer) throws XMLStreamException {
        if (rational == null) {
            return;
        }
        writer.writeStartElement(RATIONAL);
        writer.writeln();
        writer.writeElementChars(NUMERATOR, "" + rational.getNumerator());
        writer.writeElementChars(DENOMINATOR, "" + rational.getDenominator());
        writer.writeEndElement();
        writer.writeln();
    }
}

