/*
 * Decompiled with CFR 0.152.
 */
package org.xmcda.parsers.xml.xmcda_v3;

import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.xmcda.Factory;
import org.xmcda.QuantitativeScale;
import org.xmcda.Scale;
import org.xmcda.XMCDA;
import org.xmcda.parsers.xml.xmcda_v3.QualifiedValueParser;
import org.xmcda.parsers.xml.xmcda_v3.Utils;
import org.xmcda.parsers.xml.xmcda_v3.XMLStreamWriter;

public class QuantitativeScaleParser {
    public static final String QUANTITATIVE = "quantitative";
    public static final String MINIMUM = "minimum";
    public static final String MAXIMUM = "maximum";

    public QuantitativeScale<?> fromXML(XMCDA xmcda, StartElement startElement, XMLEventReader eventReader) throws XMLStreamException {
        XMLEvent event;
        QuantitativeScale scale = Factory.quantitativeScale();
        while (!(!eventReader.hasNext() || (event = eventReader.nextEvent()).isEndElement() && QUANTITATIVE.equals(event.asEndElement().getName().getLocalPart()))) {
            if (!event.isStartElement()) continue;
            startElement = event.asStartElement();
            if ("preferenceDirection".equals(startElement.getName().getLocalPart())) {
                String prefDir = Utils.getTextContent(startElement, eventReader).toUpperCase();
                scale.setPreferenceDirection(Scale.PreferenceDirection.valueOf(prefDir));
                continue;
            }
            if (MINIMUM.equals(startElement.getName().getLocalPart())) {
                scale.setMinimum(new QualifiedValueParser().fromXML(xmcda, startElement, eventReader));
                continue;
            }
            if (!MAXIMUM.equals(startElement.getName().getLocalPart())) continue;
            scale.setMaximum(new QualifiedValueParser().fromXML(xmcda, startElement, eventReader));
        }
        return scale;
    }

    public void toXML(QuantitativeScale<?> scale, XMLStreamWriter writer) throws XMLStreamException {
        if (scale == null) {
            return;
        }
        writer.writeStartElement(QUANTITATIVE);
        writer.writeln();
        writer.writeElementChars("preferenceDirection", scale.getPreferenceDirection().toString().toLowerCase());
        new QualifiedValueParser().toXML(MINIMUM, scale.getMinimum(), writer);
        new QualifiedValueParser().toXML(MAXIMUM, scale.getMaximum(), writer);
        writer.writeEndElement();
        writer.writeln();
    }
}

