/*
 * Decompiled with CFR 0.152.
 */
package org.xmcda.parsers.xml.xmcda_v3;

import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.xmcda.Factory;
import org.xmcda.QualitativeScale;
import org.xmcda.Scale;
import org.xmcda.XMCDA;
import org.xmcda.parsers.xml.xmcda_v3.Utils;
import org.xmcda.parsers.xml.xmcda_v3.ValuedLabelParser;
import org.xmcda.parsers.xml.xmcda_v3.XMLStreamWriter;
import org.xmcda.value.ValuedLabel;

public class QualitativeScaleParser {
    public static final String QUALITATIVE = "qualitative";
    public static final String VALUED_LABELS = "valuedLabels";

    public QualitativeScale<?> fromXML(XMCDA xmcda, StartElement startElement, XMLEventReader eventReader) throws XMLStreamException {
        XMLEvent event;
        QualitativeScale scale = Factory.qualitativeScale();
        while (!(!eventReader.hasNext() || (event = eventReader.nextEvent()).isEndElement() && QUALITATIVE.equals(event.asEndElement().getName().getLocalPart()))) {
            if (!event.isStartElement()) continue;
            startElement = event.asStartElement();
            if ("preferenceDirection".equals(startElement.getName().getLocalPart())) {
                String prefDir = Utils.getTextContent(startElement, eventReader).toUpperCase();
                scale.setPreferenceDirection(Scale.PreferenceDirection.valueOf(prefDir));
            }
            if (!VALUED_LABELS.equals(startElement.getName().getLocalPart())) continue;
            this.valuedLabelsFromXML(xmcda, scale, startElement, eventReader);
        }
        return scale;
    }

    protected void valuedLabelsFromXML(XMCDA xmcda, QualitativeScale<?> scale, StartElement startElement, XMLEventReader eventReader) throws XMLStreamException {
        XMLEvent event;
        while (!(!eventReader.hasNext() || (event = eventReader.nextEvent()).isEndElement() && VALUED_LABELS.equals(event.asEndElement().getName().getLocalPart()))) {
            if (!event.isStartElement() || !ValuedLabelParser.VALUED_LABEL.equals((startElement = event.asStartElement()).getName().getLocalPart())) continue;
            scale.add(new ValuedLabelParser().fromXML(xmcda, startElement, eventReader));
        }
    }

    public void toXML(QualitativeScale<?> scale, XMLStreamWriter writer) throws XMLStreamException {
        if (scale == null) {
            return;
        }
        writer.writeStartElement(QUALITATIVE);
        writer.writeln();
        writer.writeElementChars("preferenceDirection", scale.getPreferenceDirection().toString().toLowerCase());
        writer.writeStartElement(VALUED_LABELS);
        writer.writeln();
        for (ValuedLabel valuedLabel : scale) {
            new ValuedLabelParser().toXML(valuedLabel, writer);
        }
        writer.writeEndElement();
        writer.writeln();
        writer.writeEndElement();
        writer.writeln();
    }
}

