/*
 * Decompiled with CFR 0.152.
 */
package org.xmcda.parsers.xml.xmcda_v3;

import java.util.List;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.xmcda.Factory;
import org.xmcda.ProgramParameter;
import org.xmcda.ProgramParameters;
import org.xmcda.XMCDA;
import org.xmcda.parsers.xml.xmcda_v3.CommonAttributesParser;
import org.xmcda.parsers.xml.xmcda_v3.DescriptionParser;
import org.xmcda.parsers.xml.xmcda_v3.ProgramParameterParser;
import org.xmcda.parsers.xml.xmcda_v3.XMLStreamWriter;

public class ProgramParametersParser<VALUE_TYPE> {
    public static final String PROGRAM_PARAMETERS = "programParameters";

    public ProgramParameters<VALUE_TYPE> fromXML(XMCDA xmcda, StartElement startElement, XMLEventReader eventReader) throws XMLStreamException {
        XMLEvent event;
        ProgramParameters prgParameters = Factory.programParameters();
        new CommonAttributesParser().handleAttributes(prgParameters, startElement);
        while (!(!eventReader.hasNext() || (event = eventReader.nextEvent()).isEndElement() && PROGRAM_PARAMETERS.equals(event.asEndElement().getName().getLocalPart()))) {
            if (!event.isStartElement()) continue;
            startElement = event.asStartElement();
            String currentTagName = startElement.getName().getLocalPart();
            if ("description".equals(currentTagName)) {
                prgParameters.setDescription(new DescriptionParser().fromXML(xmcda, startElement, eventReader));
            }
            if (!"parameter".equals(currentTagName)) continue;
            prgParameters.add(new ProgramParameterParser().fromXML(xmcda, startElement, eventReader));
        }
        return prgParameters;
    }

    public void toXML(List<ProgramParameters<VALUE_TYPE>> list, XMLStreamWriter writer) throws XMLStreamException {
        if (list == null || list.size() == 0) {
            return;
        }
        for (ProgramParameters<VALUE_TYPE> programParameters : list) {
            this.toXML(programParameters, writer);
        }
    }

    public void toXML(ProgramParameters<VALUE_TYPE> programParameters, XMLStreamWriter writer) throws XMLStreamException {
        if (programParameters == null) {
            return;
        }
        writer.writeStartElement(PROGRAM_PARAMETERS);
        new CommonAttributesParser().toXML(programParameters, writer);
        writer.writeln();
        new DescriptionParser().toXML(programParameters.getDescription(), writer);
        ProgramParameterParser programParameterParser = new ProgramParameterParser();
        for (ProgramParameter programParameter : programParameters) {
            programParameterParser.toXML(programParameter, writer);
        }
        writer.writeEndElement();
        writer.writeln();
    }
}

