/*
 * Decompiled with CFR 0.152.
 */
package org.xmcda.parsers.xml.xmcda_v3;

import java.util.List;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.xmcda.Message;
import org.xmcda.ProgramExecutionResult;
import org.xmcda.XMCDA;
import org.xmcda.parsers.xml.xmcda_v3.CommonAttributesParser;
import org.xmcda.parsers.xml.xmcda_v3.DescriptionParser;
import org.xmcda.parsers.xml.xmcda_v3.MessageParser;
import org.xmcda.parsers.xml.xmcda_v3.Utils;
import org.xmcda.parsers.xml.xmcda_v3.XMLStreamWriter;

public class ProgramExecutionResultParser {
    public static final String PROGRAM_EXECUTION_RESULT = "programExecutionResult";
    public static final String MESSAGES = "messages";
    public static final String STATUS = "status";

    public ProgramExecutionResult fromXML(XMCDA xmcda, StartElement startElement, XMLEventReader eventReader) throws XMLStreamException {
        XMLEvent event;
        ProgramExecutionResult executionResult = new ProgramExecutionResult();
        new CommonAttributesParser().handleAttributes(executionResult, startElement);
        while (!(!eventReader.hasNext() || (event = eventReader.nextEvent()).isEndElement() && PROGRAM_EXECUTION_RESULT.equals(event.asEndElement().getName().getLocalPart()))) {
            if (!event.isStartElement()) continue;
            startElement = event.asStartElement();
            String currentTagName = startElement.getName().getLocalPart();
            if ("description".equals(currentTagName)) {
                executionResult.setDescription(new DescriptionParser().fromXML(xmcda, startElement, eventReader));
            }
            if (STATUS.equals(currentTagName)) {
                String status = Utils.getTextContent(startElement, eventReader);
                executionResult.updateStatus(ProgramExecutionResult.Status.valueOf(status.toUpperCase()));
            }
            if (!MESSAGES.equals(currentTagName)) continue;
            this.messagesFromXML(xmcda, executionResult, startElement, eventReader);
        }
        return executionResult;
    }

    void messagesFromXML(XMCDA xmcda, ProgramExecutionResult executionResult, StartElement startElement, XMLEventReader eventReader) throws XMLStreamException {
        XMLEvent event;
        while (!(!eventReader.hasNext() || (event = eventReader.nextEvent()).isEndElement() && MESSAGES.equals(event.asEndElement().getName().getLocalPart()))) {
            String currentTagName;
            if (!event.isStartElement() || !"message".equals(currentTagName = (startElement = event.asStartElement()).getName().getLocalPart())) continue;
            executionResult.add(new MessageParser().fromXML(xmcda, startElement, eventReader));
        }
    }

    public void toXML(List<ProgramExecutionResult> execResults, XMLStreamWriter writer) throws XMLStreamException {
        if (execResults == null || execResults.size() == 0) {
            return;
        }
        for (ProgramExecutionResult result : execResults) {
            this.toXML(result, writer);
        }
    }

    public void toXML(ProgramExecutionResult prgExecResults, XMLStreamWriter writer) throws XMLStreamException {
        if (prgExecResults == null) {
            return;
        }
        writer.writeStartElement(PROGRAM_EXECUTION_RESULT);
        new CommonAttributesParser().toXML(prgExecResults, writer);
        writer.writeln();
        new DescriptionParser().toXML(prgExecResults.getDescription(), writer);
        if (prgExecResults.getStatus() != null) {
            writer.writeElementChars(STATUS, prgExecResults.getStatus().name().toLowerCase());
        }
        if (prgExecResults != null && prgExecResults.size() > 0) {
            writer.writeStartElement(MESSAGES);
            writer.writeln();
            MessageParser messageParser = new MessageParser();
            for (Message message : prgExecResults) {
                messageParser.toXML(message, writer);
            }
            writer.writeEndElement();
            writer.writeln();
        }
        writer.writeEndElement();
        writer.writeln();
    }
}

