/*
 * Decompiled with CFR 0.152.
 */
package org.xmcda.parsers.xml.xmcda_v3;

import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.xmcda.CommonAttributes;
import org.xmcda.Factory;
import org.xmcda.LinearConstraint;
import org.xmcda.ObjectsLinearConstraints;
import org.xmcda.XMCDA;
import org.xmcda.parsers.xml.xmcda_v3.CommonAttributesParser;
import org.xmcda.parsers.xml.xmcda_v3.DescriptionParser;
import org.xmcda.parsers.xml.xmcda_v3.LinearConstraintParser;
import org.xmcda.parsers.xml.xmcda_v3.VariablesParser;
import org.xmcda.parsers.xml.xmcda_v3.XMLStreamWriter;

public abstract class ObjectsLinearConstraintsParser<ELEMENT extends CommonAttributes, VALUE_TYPE> {
    public abstract String rootTag();

    public abstract String objectReferenceTag();

    public abstract LinearConstraintParser.LinearConstraintParserHelper<ELEMENT> helper();

    public ObjectsLinearConstraints<ELEMENT, VALUE_TYPE> fromXML(XMCDA xmcda, StartElement startElement, XMLEventReader eventReader) throws XMLStreamException {
        XMLEvent event;
        ObjectsLinearConstraints constraints = Factory.build(ObjectsLinearConstraints.class);
        new CommonAttributesParser().handleAttributes(constraints, startElement);
        while (!(!eventReader.hasNext() || (event = eventReader.nextEvent()).isEndElement() && this.rootTag().equals(event.asEndElement().getName().getLocalPart()))) {
            if (!event.isStartElement()) continue;
            startElement = event.asStartElement();
            if ("description".equals(startElement.getName().getLocalPart())) {
                constraints.setDescription(new DescriptionParser().fromXML(xmcda, startElement, eventReader));
            }
            if ("variables".equals(startElement.getName().getLocalPart())) {
                constraints.setVariables(new VariablesParser().fromXML(xmcda, startElement, eventReader));
            }
            if (!"constraints".equals(startElement.getName().getLocalPart())) continue;
            this.readConstraintsFromXML(xmcda, constraints, startElement, eventReader);
        }
        return constraints;
    }

    public void readConstraintsFromXML(XMCDA xmcda, ObjectsLinearConstraints<ELEMENT, VALUE_TYPE> constraints, StartElement startElement, XMLEventReader eventReader) throws XMLStreamException {
        XMLEvent event;
        while (!(!eventReader.hasNext() || (event = eventReader.nextEvent()).isEndElement() && "constraints".equals(event.asEndElement().getName().getLocalPart()))) {
            if (!event.isStartElement() || !"constraint".equals((startElement = event.asStartElement()).getName().getLocalPart())) continue;
            constraints.add(new LinearConstraintParser().constraintFromXML(xmcda, this.helper(), startElement, eventReader));
        }
    }

    public void toXML(ObjectsLinearConstraints<ELEMENT, VALUE_TYPE> constraints, XMLStreamWriter writer) throws XMLStreamException {
        if (constraints == null) {
            return;
        }
        writer.writeStartElement(this.rootTag());
        new CommonAttributesParser().toXML(constraints, writer);
        writer.writeln();
        new DescriptionParser().toXML(constraints.getDescription(), writer);
        new VariablesParser().toXML(constraints.getVariables(), writer);
        writer.writeStartElement("constraints");
        writer.writeln();
        for (LinearConstraint linearConstraint : constraints) {
            new LinearConstraintParser().toXML(this.objectReferenceTag(), linearConstraint, writer);
        }
        writer.writeEndElement();
        writer.writeln();
        writer.writeEndElement();
        writer.writeln();
    }
}

