/*
 * Decompiled with CFR 0.152.
 */
package org.xmcda.parsers.xml.xmcda_v3;

import java.util.LinkedHashSet;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.xmcda.Factory;
import org.xmcda.QualifiedValues;
import org.xmcda.XMCDA;
import org.xmcda.parsers.xml.xmcda_v3.CommonAttributesParser;
import org.xmcda.parsers.xml.xmcda_v3.DescriptionParser;
import org.xmcda.parsers.xml.xmcda_v3.QualifiedValuesParser;
import org.xmcda.parsers.xml.xmcda_v3.ScaleParser;
import org.xmcda.parsers.xml.xmcda_v3.Utils;
import org.xmcda.parsers.xml.xmcda_v3.XMLStreamWriter;
import org.xmcda.utils.Coord;
import org.xmcda.utils.Matrix;

public abstract class MatrixParser<DIMENSION, VALUE_TYPE> {
    public static final String VALUATION = "valuation";
    public static final String ROW = "row";
    public static final String COLUMN = "column";

    public abstract String rootTag();

    public abstract String dimensionTag();

    public abstract DIMENSION buildDimension(XMCDA var1, String var2);

    public abstract String dimensionID(DIMENSION var1);

    public Matrix<DIMENSION, VALUE_TYPE> fromXML(XMCDA xmcda, StartElement startElement, XMLEventReader eventReader) throws XMLStreamException {
        XMLEvent event;
        String initialTag = startElement.getName().getLocalPart();
        Matrix matrix = Factory.matrix();
        new CommonAttributesParser().handleAttributes(matrix, startElement);
        while (!(!eventReader.hasNext() || (event = eventReader.nextEvent()).isEndElement() && initialTag.equals(event.asEndElement().getName().getLocalPart()))) {
            if (!event.isStartElement()) continue;
            startElement = event.asStartElement();
            if ("description".equals(startElement.getName().getLocalPart())) {
                matrix.setDescription(new DescriptionParser().fromXML(xmcda, startElement, eventReader));
            }
            if (VALUATION.equals(startElement.getName().getLocalPart())) {
                matrix.setValuation(new ScaleParser().fromXML(xmcda, startElement, eventReader));
            }
            if (!ROW.equals(startElement.getName().getLocalPart())) continue;
            this.readRowsFromXML(xmcda, matrix, startElement, eventReader);
        }
        return matrix;
    }

    public void readRowsFromXML(XMCDA xmcda, Matrix<DIMENSION, VALUE_TYPE> matrix, StartElement startElement, XMLEventReader eventReader) throws XMLStreamException {
        XMLEvent event;
        DIMENSION row = null;
        while (!(!eventReader.hasNext() || (event = eventReader.nextEvent()).isEndElement() && ROW.equals(event.asEndElement().getName().getLocalPart()))) {
            if (!event.isStartElement()) continue;
            startElement = event.asStartElement();
            if (this.dimensionTag().equals(startElement.getName().getLocalPart())) {
                row = this.buildDimension(xmcda, Utils.getTextContent(startElement, eventReader));
            }
            if (!COLUMN.equals(startElement.getName().getLocalPart())) continue;
            this.readColumnsFromXML(xmcda, matrix, row, startElement, eventReader);
        }
    }

    public void readColumnsFromXML(XMCDA xmcda, Matrix<DIMENSION, VALUE_TYPE> matrix, DIMENSION row, StartElement startElement, XMLEventReader eventReader) throws XMLStreamException {
        XMLEvent event;
        Object column = null;
        while (!(!eventReader.hasNext() || (event = eventReader.nextEvent()).isEndElement() && COLUMN.equals(event.asEndElement().getName().getLocalPart()))) {
            if (!event.isStartElement()) continue;
            startElement = event.asStartElement();
            if (this.dimensionTag().equals(startElement.getName().getLocalPart())) {
                column = this.buildDimension(xmcda, Utils.getTextContent(startElement, eventReader));
            }
            if (!"values".equals(startElement.getName().getLocalPart())) continue;
            QualifiedValues values = new QualifiedValuesParser().fromXML(xmcda, startElement, eventReader);
            matrix.put(new Coord<DIMENSION, Object>(row, column), values);
        }
    }

    protected LinkedHashSet<DIMENSION> columnsForRow(Matrix<DIMENSION, VALUE_TYPE> matrix, DIMENSION row) {
        LinkedHashSet set = new LinkedHashSet();
        for (Coord coord : matrix.keySet()) {
            if (!coord.x.equals(row)) continue;
            set.add(coord.y);
        }
        return set;
    }

    public void toXML(Matrix<DIMENSION, VALUE_TYPE> matrix, XMLStreamWriter writer) throws XMLStreamException {
        if (matrix == null) {
            return;
        }
        writer.writeStartElement(this.rootTag());
        new CommonAttributesParser().toXML(matrix, writer);
        writer.writeln();
        new DescriptionParser().toXML(matrix.getDescription(), writer);
        new ScaleParser().toXML(VALUATION, matrix.getValuation(), writer);
        for (DIMENSION row : matrix.getRows()) {
            writer.writeStartElement(ROW);
            writer.writeln();
            writer.writeElementChars(this.dimensionTag(), this.dimensionID(row));
            for (Object column : this.columnsForRow(matrix, row)) {
                QualifiedValues<VALUE_TYPE> values = matrix.get(row, column);
                if (values == null) continue;
                writer.writeStartElement(COLUMN);
                writer.writeln();
                writer.writeElementChars(this.dimensionTag(), this.dimensionID(column));
                new QualifiedValuesParser<VALUE_TYPE>().toXML(values, writer);
                writer.writeEndElement();
                writer.writeln();
            }
            writer.writeEndElement();
            writer.writeln();
        }
        writer.writeEndElement();
        writer.writeln();
    }
}

