/*
 * Decompiled with CFR 0.152.
 */
package org.xmcda.parsers.xml.xmcda_v3;

import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.xmcda.CriteriaValues;
import org.xmcda.Criterion;
import org.xmcda.Factory;
import org.xmcda.LabelledQValues;
import org.xmcda.XMCDA;
import org.xmcda.parsers.xml.xmcda_v3.CommonAttributesParser;
import org.xmcda.parsers.xml.xmcda_v3.DescriptionParser;
import org.xmcda.parsers.xml.xmcda_v3.QualifiedValuesParser;
import org.xmcda.parsers.xml.xmcda_v3.Utils;
import org.xmcda.parsers.xml.xmcda_v3.XMLStreamWriter;

public class CriterionValuesParser<VALUE_TYPE> {
    public static final String CRITERION_VALUE = "criterionValue";
    public static final String CRITERION_ID = "criterionID";

    public Criterion fromXML(XMCDA xmcda, CriteriaValues<VALUE_TYPE> objectsValues, StartElement startElement, XMLEventReader eventReader) throws XMLStreamException {
        XMLEvent event;
        LabelledQValues criterionValues = Factory.labelledQValues();
        new CommonAttributesParser().handleAttributes(criterionValues, startElement);
        Criterion criterion = null;
        while (!(!eventReader.hasNext() || (event = eventReader.nextEvent()).isEndElement() && CRITERION_VALUE.equals(event.asEndElement().getName().getLocalPart()))) {
            if (!event.isStartElement()) continue;
            startElement = event.asStartElement();
            if ("description".equals(startElement.getName().getLocalPart())) {
                criterionValues.setDescription(new DescriptionParser().fromXML(xmcda, startElement, eventReader));
            }
            if ("values".equals(startElement.asStartElement().getName().getLocalPart())) {
                criterionValues.addAll(new QualifiedValuesParser().fromXML(xmcda, startElement, eventReader));
            }
            if (!CRITERION_ID.equals(startElement.getName().getLocalPart())) continue;
            String id = Utils.getTextContent(startElement, eventReader);
            criterion = (Criterion)xmcda.criteria.get(id);
        }
        objectsValues.put(criterion, criterionValues);
        return criterion;
    }

    public void toXML(Criterion criterion, LabelledQValues<VALUE_TYPE> criterionValues, XMLStreamWriter writer) throws XMLStreamException {
        if (criterionValues == null) {
            return;
        }
        writer.writeStartElement(CRITERION_VALUE);
        new CommonAttributesParser().toXML(criterionValues, writer);
        writer.writeln();
        new DescriptionParser().toXML(criterionValues.getDescription(), writer);
        writer.writeElementChars(CRITERION_ID, criterion.id());
        new QualifiedValuesParser<VALUE_TYPE>().toXML(criterionValues, writer);
        writer.writeEndElement();
        writer.writeln();
    }
}

