/*
 * Decompiled with CFR 0.152.
 */
package org.xmcda.parsers.xml.xmcda_v3;

import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.xmcda.CriteriaFunctions;
import org.xmcda.Criterion;
import org.xmcda.CriterionFunctions;
import org.xmcda.XMCDA;
import org.xmcda.parsers.xml.xmcda_v3.CommonAttributesParser;
import org.xmcda.parsers.xml.xmcda_v3.DescriptionParser;
import org.xmcda.parsers.xml.xmcda_v3.FunctionsParser;
import org.xmcda.parsers.xml.xmcda_v3.Utils;
import org.xmcda.parsers.xml.xmcda_v3.XMLStreamWriter;

public class CriterionFunctionsParser {
    public static final String CRITERION_FUNCTION = "criterionFunction";
    public static final String CRITERION_ID = "criterionID";

    public Criterion fromXML(XMCDA xmcda, CriteriaFunctions criteriaFunctions, StartElement startElement, XMLEventReader eventReader) throws XMLStreamException {
        XMLEvent event;
        CriterionFunctions criterionFunctions = new CriterionFunctions();
        new CommonAttributesParser().handleAttributes(criterionFunctions, startElement);
        Criterion criterion = null;
        while (!(!eventReader.hasNext() || (event = eventReader.nextEvent()).isEndElement() && CRITERION_FUNCTION.equals(event.asEndElement().getName().getLocalPart()))) {
            if (!event.isStartElement()) continue;
            startElement = event.asStartElement();
            if ("description".equals(startElement.getName().getLocalPart())) {
                criterionFunctions.setDescription(new DescriptionParser().fromXML(xmcda, startElement, eventReader));
            }
            if ("functions".equals(startElement.asStartElement().getName().getLocalPart())) {
                criterionFunctions.addAll(new FunctionsParser().fromXML(xmcda, startElement, eventReader));
            }
            if (!CRITERION_ID.equals(startElement.getName().getLocalPart())) continue;
            String criterionID = Utils.getTextContent(startElement, eventReader);
            criterion = (Criterion)xmcda.criteria.get(criterionID);
        }
        criteriaFunctions.put(criterion, criterionFunctions);
        return criterion;
    }

    public void toXML(String criterionID, CriterionFunctions criterionFunctions, XMLStreamWriter writer) throws XMLStreamException {
        if (criterionFunctions == null) {
            return;
        }
        writer.writeStartElement(CRITERION_FUNCTION);
        new CommonAttributesParser().toXML(criterionFunctions, writer);
        writer.writeln();
        new DescriptionParser().toXML(criterionFunctions.getDescription(), writer);
        writer.writeElementChars(CRITERION_ID, criterionID);
        new FunctionsParser().toXML(criterionFunctions, writer);
        writer.writeEndElement();
        writer.writeln();
    }
}

