/*
 * Decompiled with CFR 0.152.
 */
package org.xmcda.parsers.xml.xmcda_v3;

import java.util.List;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.xmcda.CriteriaSet;
import org.xmcda.CriteriaSetsLinearConstraints;
import org.xmcda.Factory;
import org.xmcda.LinearConstraint;
import org.xmcda.XMCDA;
import org.xmcda.parsers.xml.xmcda_v3.CommonAttributesParser;
import org.xmcda.parsers.xml.xmcda_v3.DescriptionParser;
import org.xmcda.parsers.xml.xmcda_v3.LinearConstraintParser;
import org.xmcda.parsers.xml.xmcda_v3.VariablesParser;
import org.xmcda.parsers.xml.xmcda_v3.XMLStreamWriter;

public class CriteriaSetsLinearConstraintsParser<CRITERIASET_VALUE_TYPE, VALUE_TYPE> {
    public static final String CRITERIA_SETS_LINEAR_CONSTRAINTS = "criteriaSetsLinearConstraints";
    public static final String CRITERIA_SET_ID = "criteriaSetID";

    public LinearConstraintParser.LinearConstraintParserHelper<CriteriaSet<CRITERIASET_VALUE_TYPE>> helper() {
        return new Helper();
    }

    public CriteriaSetsLinearConstraints<CRITERIASET_VALUE_TYPE, VALUE_TYPE> fromXML(XMCDA xmcda, StartElement startElement, XMLEventReader eventReader) throws XMLStreamException {
        XMLEvent event;
        CriteriaSetsLinearConstraints constraints = Factory.criteriaSetsLinearConstraints();
        new CommonAttributesParser().handleAttributes(constraints, startElement);
        while (!(!eventReader.hasNext() || (event = eventReader.nextEvent()).isEndElement() && CRITERIA_SETS_LINEAR_CONSTRAINTS.equals(event.asEndElement().getName().getLocalPart()))) {
            if (!event.isStartElement()) continue;
            startElement = event.asStartElement();
            if ("description".equals(startElement.getName().getLocalPart())) {
                constraints.setDescription(new DescriptionParser().fromXML(xmcda, startElement, eventReader));
            }
            if ("variables".equals(startElement.getName().getLocalPart())) {
                constraints.setVariables(new VariablesParser().fromXML(xmcda, startElement, eventReader));
            }
            if (!"constraints".equals(startElement.getName().getLocalPart())) continue;
            this.readConstraintsFromXML(xmcda, constraints, startElement, eventReader);
        }
        return constraints;
    }

    public void readConstraintsFromXML(XMCDA xmcda, CriteriaSetsLinearConstraints<CRITERIASET_VALUE_TYPE, VALUE_TYPE> constraints, StartElement startElement, XMLEventReader eventReader) throws XMLStreamException {
        XMLEvent event;
        while (!(!eventReader.hasNext() || (event = eventReader.nextEvent()).isEndElement() && "constraints".equals(event.asEndElement().getName().getLocalPart()))) {
            if (!event.isStartElement() || !"constraint".equals((startElement = event.asStartElement()).getName().getLocalPart())) continue;
            constraints.add(new LinearConstraintParser().constraintFromXML(xmcda, this.helper(), startElement, eventReader));
        }
    }

    public void toXML(List<CriteriaSetsLinearConstraints<CRITERIASET_VALUE_TYPE, VALUE_TYPE>> list, XMLStreamWriter writer) throws XMLStreamException {
        if (list == null || list.size() == 0) {
            return;
        }
        for (CriteriaSetsLinearConstraints<CRITERIASET_VALUE_TYPE, VALUE_TYPE> values : list) {
            this.toXML(values, writer);
        }
    }

    public void toXML(CriteriaSetsLinearConstraints<CRITERIASET_VALUE_TYPE, VALUE_TYPE> constraints, XMLStreamWriter writer) throws XMLStreamException {
        if (constraints == null) {
            return;
        }
        writer.writeStartElement(CRITERIA_SETS_LINEAR_CONSTRAINTS);
        new CommonAttributesParser().toXML(constraints, writer);
        writer.writeln();
        new DescriptionParser().toXML(constraints.getDescription(), writer);
        new VariablesParser().toXML(constraints.getVariables(), writer);
        writer.writeStartElement("constraints");
        writer.writeln();
        for (LinearConstraint linearConstraint : constraints) {
            new LinearConstraintParser().toXML(CRITERIA_SET_ID, linearConstraint, writer);
        }
        writer.writeEndElement();
        writer.writeln();
        writer.writeEndElement();
        writer.writeln();
    }

    private class Helper
    extends LinearConstraintParser.LinearConstraintParserHelper<CriteriaSet<CRITERIASET_VALUE_TYPE>> {
        private Helper() {
        }

        @Override
        public CriteriaSet<CRITERIASET_VALUE_TYPE> buildObject(XMCDA xmcda, String id) {
            return (CriteriaSet)xmcda.criteriaSets.get(id);
        }
    }
}

