/*
 * Decompiled with CFR 0.152.
 */
package org.xmcda.parsers.xml.xmcda_v3;

import java.util.List;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.xmcda.CriteriaLinearConstraints;
import org.xmcda.Criterion;
import org.xmcda.Factory;
import org.xmcda.LinearConstraint;
import org.xmcda.XMCDA;
import org.xmcda.parsers.xml.xmcda_v3.CommonAttributesParser;
import org.xmcda.parsers.xml.xmcda_v3.DescriptionParser;
import org.xmcda.parsers.xml.xmcda_v3.LinearConstraintParser;
import org.xmcda.parsers.xml.xmcda_v3.VariablesParser;
import org.xmcda.parsers.xml.xmcda_v3.XMLStreamWriter;

public class CriteriaLinearConstraintsParser<VALUE_TYPE> {
    public static final String CRITERIA_LINEAR_CONSTRAINTS = "criteriaLinearConstraints";
    public static final String CRITERION_ID = "criterionID";

    public LinearConstraintParser.LinearConstraintParserHelper<Criterion> helper() {
        return new Helper();
    }

    public CriteriaLinearConstraints<VALUE_TYPE> fromXML(XMCDA xmcda, StartElement startElement, XMLEventReader eventReader) throws XMLStreamException {
        XMLEvent event;
        CriteriaLinearConstraints constraints = Factory.criteriaLinearConstraints();
        new CommonAttributesParser().handleAttributes(constraints, startElement);
        while (!(!eventReader.hasNext() || (event = eventReader.nextEvent()).isEndElement() && CRITERIA_LINEAR_CONSTRAINTS.equals(event.asEndElement().getName().getLocalPart()))) {
            if (!event.isStartElement()) continue;
            startElement = event.asStartElement();
            if ("description".equals(startElement.getName().getLocalPart())) {
                constraints.setDescription(new DescriptionParser().fromXML(xmcda, startElement, eventReader));
            }
            if ("variables".equals(startElement.getName().getLocalPart())) {
                constraints.setVariables(new VariablesParser().fromXML(xmcda, startElement, eventReader));
            }
            if (!"constraints".equals(startElement.getName().getLocalPart())) continue;
            this.readConstraintsFromXML(xmcda, constraints, startElement, eventReader);
        }
        return constraints;
    }

    public void readConstraintsFromXML(XMCDA xmcda, CriteriaLinearConstraints<VALUE_TYPE> constraints, StartElement startElement, XMLEventReader eventReader) throws XMLStreamException {
        XMLEvent event;
        while (!(!eventReader.hasNext() || (event = eventReader.nextEvent()).isEndElement() && "constraints".equals(event.asEndElement().getName().getLocalPart()))) {
            if (!event.isStartElement() || !"constraint".equals((startElement = event.asStartElement()).getName().getLocalPart())) continue;
            constraints.add(new LinearConstraintParser().constraintFromXML(xmcda, this.helper(), startElement, eventReader));
        }
    }

    public void toXML(List<CriteriaLinearConstraints<VALUE_TYPE>> list, XMLStreamWriter writer) throws XMLStreamException {
        if (list == null || list.size() == 0) {
            return;
        }
        for (CriteriaLinearConstraints<VALUE_TYPE> constraints : list) {
            this.toXML(constraints, writer);
        }
    }

    public void toXML(CriteriaLinearConstraints<VALUE_TYPE> constraints, XMLStreamWriter writer) throws XMLStreamException {
        if (constraints == null) {
            return;
        }
        writer.writeStartElement(CRITERIA_LINEAR_CONSTRAINTS);
        new CommonAttributesParser().toXML(constraints, writer);
        writer.writeln();
        new DescriptionParser().toXML(constraints.getDescription(), writer);
        new VariablesParser().toXML(constraints.getVariables(), writer);
        writer.writeStartElement("constraints");
        writer.writeln();
        for (LinearConstraint linearConstraint : constraints) {
            new LinearConstraintParser().toXML(CRITERION_ID, linearConstraint, writer);
        }
        writer.writeEndElement();
        writer.writeln();
        writer.writeEndElement();
        writer.writeln();
    }

    private class Helper
    extends LinearConstraintParser.LinearConstraintParserHelper<Criterion> {
        private Helper() {
        }

        @Override
        public Criterion buildObject(XMCDA xmcda, String id) {
            return (Criterion)xmcda.criteria.get(id);
        }
    }
}

