/*
 * Decompiled with CFR 0.152.
 */
package org.xmcda.parsers.xml.xmcda_v3;

import java.util.List;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.xmcda.CategoriesLinearConstraints;
import org.xmcda.Category;
import org.xmcda.Factory;
import org.xmcda.LinearConstraint;
import org.xmcda.XMCDA;
import org.xmcda.parsers.xml.xmcda_v3.CommonAttributesParser;
import org.xmcda.parsers.xml.xmcda_v3.DescriptionParser;
import org.xmcda.parsers.xml.xmcda_v3.LinearConstraintParser;
import org.xmcda.parsers.xml.xmcda_v3.VariablesParser;
import org.xmcda.parsers.xml.xmcda_v3.XMLStreamWriter;

public class CategoriesLinearConstraintsParser<VALUE_TYPE> {
    public static final String CATEGORIES_LINEAR_CONSTRAINTS = "categoriesLinearConstraints";
    public static final String CATEGORY_ID = "categoryID";

    public LinearConstraintParser.LinearConstraintParserHelper<Category> helper() {
        return new Helper();
    }

    public CategoriesLinearConstraints<VALUE_TYPE> fromXML(XMCDA xmcda, StartElement startElement, XMLEventReader eventReader) throws XMLStreamException {
        XMLEvent event;
        CategoriesLinearConstraints constraints = Factory.categoriesLinearConstraints();
        new CommonAttributesParser().handleAttributes(constraints, startElement);
        while (!(!eventReader.hasNext() || (event = eventReader.nextEvent()).isEndElement() && CATEGORIES_LINEAR_CONSTRAINTS.equals(event.asEndElement().getName().getLocalPart()))) {
            if (!event.isStartElement()) continue;
            startElement = event.asStartElement();
            if ("description".equals(startElement.getName().getLocalPart())) {
                constraints.setDescription(new DescriptionParser().fromXML(xmcda, startElement, eventReader));
            }
            if ("variables".equals(startElement.getName().getLocalPart())) {
                constraints.setVariables(new VariablesParser().fromXML(xmcda, startElement, eventReader));
            }
            if (!"constraints".equals(startElement.getName().getLocalPart())) continue;
            this.readConstraintsFromXML(xmcda, constraints, startElement, eventReader);
        }
        return constraints;
    }

    public void readConstraintsFromXML(XMCDA xmcda, CategoriesLinearConstraints<VALUE_TYPE> constraints, StartElement startElement, XMLEventReader eventReader) throws XMLStreamException {
        XMLEvent event;
        while (!(!eventReader.hasNext() || (event = eventReader.nextEvent()).isEndElement() && "constraints".equals(event.asEndElement().getName().getLocalPart()))) {
            if (!event.isStartElement() || !"constraint".equals((startElement = event.asStartElement()).getName().getLocalPart())) continue;
            constraints.add(new LinearConstraintParser().constraintFromXML(xmcda, this.helper(), startElement, eventReader));
        }
    }

    public void toXML(List<CategoriesLinearConstraints<VALUE_TYPE>> list, XMLStreamWriter writer) throws XMLStreamException {
        if (list == null || list.size() == 0) {
            return;
        }
        for (CategoriesLinearConstraints<VALUE_TYPE> constraints : list) {
            this.toXML(constraints, writer);
        }
    }

    public void toXML(CategoriesLinearConstraints<VALUE_TYPE> constraints, XMLStreamWriter writer) throws XMLStreamException {
        if (constraints == null) {
            return;
        }
        writer.writeStartElement(CATEGORIES_LINEAR_CONSTRAINTS);
        new CommonAttributesParser().toXML(constraints, writer);
        writer.writeln();
        new DescriptionParser().toXML(constraints.getDescription(), writer);
        new VariablesParser().toXML(constraints.getVariables(), writer);
        writer.writeStartElement("constraints");
        writer.writeln();
        for (LinearConstraint linearConstraint : constraints) {
            new LinearConstraintParser().toXML(CATEGORY_ID, linearConstraint, writer);
        }
        writer.writeEndElement();
        writer.writeln();
        writer.writeEndElement();
        writer.writeln();
    }

    private class Helper
    extends LinearConstraintParser.LinearConstraintParserHelper<Category> {
        private Helper() {
        }

        @Override
        public Category buildObject(XMCDA xmcda, String id) {
            return (Category)xmcda.categories.get(id);
        }
    }
}

