/*
 * Decompiled with CFR 0.152.
 */
package org.xmcda.parsers.xml.xmcda_v3;

import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.xmcda.CategoriesInterval;
import org.xmcda.Category;
import org.xmcda.Factory;
import org.xmcda.XMCDA;
import org.xmcda.parsers.xml.xmcda_v3.CommonAttributesParser;
import org.xmcda.parsers.xml.xmcda_v3.DescriptionParser;
import org.xmcda.parsers.xml.xmcda_v3.Utils;
import org.xmcda.parsers.xml.xmcda_v3.XMLStreamWriter;

public class CategoriesIntervalParser {
    public static final String CATEGORIES_INTERVAL = "categoriesInterval";
    public static final String LOWER_BOUND = "lowerBound";
    public static final String UPPER_BOUND = "upperBound";
    public static final String CATEGORY_ID = "categoryID";

    public CategoriesInterval fromXML(XMCDA xmcda, StartElement startElement, XMLEventReader eventReader) throws XMLStreamException {
        XMLEvent event;
        CategoriesInterval categoriesInterval = Factory.categoriesInterval();
        new CommonAttributesParser().handleAttributes(categoriesInterval, startElement);
        while (!(!eventReader.hasNext() || (event = eventReader.nextEvent()).isEndElement() && CATEGORIES_INTERVAL.equals(event.asEndElement().getName().getLocalPart()))) {
            if (!event.isStartElement()) continue;
            startElement = event.asStartElement();
            if ("description".equals(startElement.getName().getLocalPart())) {
                categoriesInterval.setDescription(new DescriptionParser().fromXML(xmcda, startElement, eventReader));
            }
            if (LOWER_BOUND.equals(startElement.getName().getLocalPart())) {
                startElement = Utils.getNextStartElement(startElement, eventReader);
                categoriesInterval.setLowerBound((Category)xmcda.categories.get(Utils.getTextContent(startElement, eventReader)));
            }
            if (!UPPER_BOUND.equals(startElement.getName().getLocalPart())) continue;
            startElement = Utils.getNextStartElement(startElement, eventReader);
            categoriesInterval.setUpperBound((Category)xmcda.categories.get(Utils.getTextContent(startElement, eventReader)));
        }
        return categoriesInterval;
    }

    public void toXML(CategoriesInterval categoryInterval, XMLStreamWriter writer) throws XMLStreamException {
        if (categoryInterval == null) {
            return;
        }
        writer.writeStartElement(CATEGORIES_INTERVAL);
        new CommonAttributesParser().toXML(categoryInterval, writer);
        writer.writeln();
        new DescriptionParser().toXML(categoryInterval.getDescription(), writer);
        if (categoryInterval.getLowerBound() != null) {
            writer.writeStartElement(LOWER_BOUND);
            writer.writeln();
            writer.writeElementChars(CATEGORY_ID, categoryInterval.getLowerBound().id());
            writer.writeEndElement();
            writer.writeln();
        }
        if (categoryInterval.getUpperBound() != null) {
            writer.writeStartElement(UPPER_BOUND);
            writer.writeln();
            writer.writeElementChars(CATEGORY_ID, categoryInterval.getUpperBound().id());
            writer.writeEndElement();
            writer.writeln();
        }
        writer.writeEndElement();
        writer.writeln();
    }
}

