/*
 * Decompiled with CFR 0.152.
 */
package org.xmcda.parsers.xml.xmcda_v3;

import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.xmcda.Alternative;
import org.xmcda.Alternatives;
import org.xmcda.XMCDA;
import org.xmcda.parsers.xml.xmcda_v3.AlternativeParser;
import org.xmcda.parsers.xml.xmcda_v3.CommonAttributesParser;
import org.xmcda.parsers.xml.xmcda_v3.DescriptionParser;
import org.xmcda.parsers.xml.xmcda_v3.XMLStreamWriter;

public class AlternativesParser {
    public static final String ALTERNATIVES = "alternatives";

    public void fromXML(XMCDA xmcda, StartElement startElement, XMLEventReader eventReader) throws XMLStreamException {
        XMLEvent event;
        Alternatives alternatives = xmcda.alternatives;
        new CommonAttributesParser().handleAttributes(alternatives, startElement);
        while (!(!eventReader.hasNext() || (event = eventReader.nextEvent()).isEndElement() && ALTERNATIVES.equals(event.asEndElement().getName().getLocalPart()))) {
            if (!event.isStartElement()) continue;
            startElement = event.asStartElement();
            if ("description".equals(startElement.getName().getLocalPart())) {
                alternatives.setDescription(new DescriptionParser().fromXML(xmcda, startElement, eventReader));
            }
            if (!"alternative".equals(startElement.getName().getLocalPart())) continue;
            alternatives.merge(new AlternativeParser().fromXML(xmcda, startElement, eventReader));
        }
    }

    public void toXML(Alternatives alternatives, XMLStreamWriter writer) throws XMLStreamException {
        if (alternatives == null) {
            return;
        }
        if (alternatives.isVoid()) {
            return;
        }
        writer.writeStartElement(ALTERNATIVES);
        new CommonAttributesParser().toXML(alternatives, writer);
        writer.writeln();
        new DescriptionParser().toXML(alternatives.getDescription(), writer);
        for (Alternative alternative : alternatives) {
            new AlternativeParser().toXML(alternative, writer);
        }
        writer.writeEndElement();
        writer.writeln();
    }
}

