/*
 * Decompiled with CFR 0.152.
 */
package org.xmcda.parsers.xml.xmcda_v3;

import java.util.List;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.xmcda.Alternative;
import org.xmcda.AlternativesCriteriaValues;
import org.xmcda.CriteriaValues;
import org.xmcda.Factory;
import org.xmcda.XMCDA;
import org.xmcda.parsers.xml.xmcda_v3.CommonAttributesParser;
import org.xmcda.parsers.xml.xmcda_v3.CriteriaValuesParser;
import org.xmcda.parsers.xml.xmcda_v3.DescriptionParser;
import org.xmcda.parsers.xml.xmcda_v3.Utils;
import org.xmcda.parsers.xml.xmcda_v3.XMLStreamWriter;

public class AlternativesCriteriaValuesParser<VALUE_TYPE> {
    public static final String ALTERNATIVES_CRITERIA_VALUES = "alternativesCriteriaValues";
    public static final String ALTERNATIVE_CRITERIA_VALUES = "alternativeCriteriaValues";
    public static final String ALTERNATIVE_ID = "alternativeID";

    public AlternativesCriteriaValues<VALUE_TYPE> fromXML(XMCDA xmcda, StartElement startElement, XMLEventReader eventReader) throws XMLStreamException {
        XMLEvent event;
        AlternativesCriteriaValues acvs = Factory.alternativesCriteriaValues();
        new CommonAttributesParser().handleAttributes(acvs, startElement);
        while (!(!eventReader.hasNext() || (event = eventReader.nextEvent()).isEndElement() && ALTERNATIVES_CRITERIA_VALUES.equals(event.asEndElement().getName().getLocalPart()))) {
            if (!event.isStartElement()) continue;
            startElement = event.asStartElement();
            String currentTagName = startElement.getName().getLocalPart();
            if ("description".equals(currentTagName)) {
                acvs.setDescription(new DescriptionParser().fromXML(xmcda, startElement, eventReader));
                continue;
            }
            if (!ALTERNATIVE_CRITERIA_VALUES.equals(currentTagName)) continue;
            this.fromXML(xmcda, acvs, startElement, eventReader);
        }
        return acvs;
    }

    public void fromXML(XMCDA xmcda, AlternativesCriteriaValues<VALUE_TYPE> acvs, StartElement startElement, XMLEventReader eventReader) throws XMLStreamException {
        XMLEvent event;
        Alternative alternative = null;
        while (!(!eventReader.hasNext() || (event = eventReader.nextEvent()).isEndElement() && ALTERNATIVE_CRITERIA_VALUES.equals(event.asEndElement().getName().getLocalPart()))) {
            if (!event.isStartElement()) continue;
            startElement = event.asStartElement();
            String currentTagName = startElement.getName().getLocalPart();
            if (ALTERNATIVE_ID.equals(currentTagName)) {
                alternative = (Alternative)xmcda.alternatives.get(Utils.getTextContent(startElement, eventReader));
                continue;
            }
            if (!"criteriaValues".equals(currentTagName)) continue;
            acvs.put(alternative, new CriteriaValuesParser().fromXML(xmcda, startElement, eventReader));
        }
    }

    public void toXML(List<AlternativesCriteriaValues<VALUE_TYPE>> list, XMLStreamWriter writer) throws XMLStreamException {
        if (list == null || list.size() == 0) {
            return;
        }
        for (AlternativesCriteriaValues<VALUE_TYPE> acvs : list) {
            this.toXML(acvs, writer);
        }
    }

    public void toXML(AlternativesCriteriaValues<VALUE_TYPE> acvs, XMLStreamWriter writer) throws XMLStreamException {
        if (acvs == null) {
            return;
        }
        writer.writeStartElement(ALTERNATIVES_CRITERIA_VALUES);
        new CommonAttributesParser().toXML(acvs, writer);
        writer.writeln();
        new DescriptionParser().toXML(acvs.getDescription(), writer);
        for (Alternative alternative : acvs.keySet()) {
            writer.writeStartElement(ALTERNATIVE_CRITERIA_VALUES);
            writer.writeln();
            writer.writeElementChars(ALTERNATIVE_ID, alternative.id());
            new CriteriaValuesParser().toXML((CriteriaValues)acvs.get(alternative), writer);
            writer.writeEndElement();
            writer.writeln();
        }
        writer.writeEndElement();
        writer.writeln();
    }
}

