/*
 * Decompiled with CFR 0.152.
 */
package org.xmcda.parsers.xml.xmcda_v3;

import java.util.List;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.xmcda.Alternative;
import org.xmcda.AlternativeAssignment;
import org.xmcda.AlternativesAssignments;
import org.xmcda.CategoriesSet;
import org.xmcda.Category;
import org.xmcda.Factory;
import org.xmcda.XMCDA;
import org.xmcda.parsers.xml.xmcda_v3.CategoriesIntervalParser;
import org.xmcda.parsers.xml.xmcda_v3.CommonAttributesParser;
import org.xmcda.parsers.xml.xmcda_v3.DescriptionParser;
import org.xmcda.parsers.xml.xmcda_v3.QualifiedValuesParser;
import org.xmcda.parsers.xml.xmcda_v3.Utils;
import org.xmcda.parsers.xml.xmcda_v3.XMLStreamWriter;

public class AlternativesAssignmentsParser<VALUE_TYPE> {
    public static final String ALTERNATIVES_ASSIGNMENTS = "alternativesAssignments";
    public static final String ALTERNATIVE_ASSIGNMENT = "alternativeAssignment";
    public static final String ALTERNATIVE_ID = "alternativeID";
    public static final String CATEGORY_ID = "categoryID";
    public static final String CATEGORIES_SET_ID = "categoriesSetID";

    public AlternativesAssignments<VALUE_TYPE> fromXML(XMCDA xmcda, StartElement startElement, XMLEventReader eventReader) throws XMLStreamException {
        XMLEvent event;
        AlternativesAssignments altsAssignmts = Factory.alternativesAssignments();
        new CommonAttributesParser().handleAttributes(altsAssignmts, startElement);
        while (!(!eventReader.hasNext() || (event = eventReader.nextEvent()).isEndElement() && ALTERNATIVES_ASSIGNMENTS.equals(event.asEndElement().getName().getLocalPart()))) {
            if (!event.isStartElement()) continue;
            startElement = event.asStartElement();
            String currentTagName = startElement.getName().getLocalPart();
            if ("description".equals(currentTagName)) {
                altsAssignmts.setDescription(new DescriptionParser().fromXML(xmcda, startElement, eventReader));
            }
            if (!ALTERNATIVE_ASSIGNMENT.equals(currentTagName)) continue;
            altsAssignmts.add(this.alternativeAssignmentFromXML(xmcda, startElement, eventReader));
        }
        return altsAssignmts;
    }

    protected AlternativeAssignment<VALUE_TYPE> alternativeAssignmentFromXML(XMCDA xmcda, StartElement startElement, XMLEventReader eventReader) throws XMLStreamException {
        XMLEvent event;
        AlternativeAssignment altAssignt = Factory.alternativeAssignment();
        new CommonAttributesParser().handleAttributes(altAssignt, startElement);
        while (!(!eventReader.hasNext() || (event = eventReader.nextEvent()).isEndElement() && ALTERNATIVE_ASSIGNMENT.equals(event.asEndElement().getName().getLocalPart()))) {
            if (!event.isStartElement()) continue;
            startElement = event.asStartElement();
            String currentTagName = startElement.getName().getLocalPart();
            if ("description".equals(currentTagName)) {
                altAssignt.setDescription(new DescriptionParser().fromXML(xmcda, startElement, eventReader));
                continue;
            }
            if (ALTERNATIVE_ID.equals(currentTagName)) {
                altAssignt.setAlternative((Alternative)xmcda.alternatives.get(Utils.getTextContent(startElement, eventReader)));
                continue;
            }
            if (CATEGORY_ID.equals(currentTagName)) {
                altAssignt.setCategory((Category)xmcda.categories.get(Utils.getTextContent(startElement, eventReader)));
                continue;
            }
            if (CATEGORIES_SET_ID.equals(currentTagName)) {
                altAssignt.setCategoriesSet((CategoriesSet)xmcda.categoriesSets.get(Utils.getTextContent(startElement, eventReader)));
                continue;
            }
            if ("categoriesInterval".equals(currentTagName)) {
                altAssignt.setCategoryInterval(new CategoriesIntervalParser().fromXML(xmcda, startElement, eventReader));
                continue;
            }
            if (!"values".equals(currentTagName)) continue;
            altAssignt.setValues(new QualifiedValuesParser().fromXML(xmcda, startElement, eventReader));
        }
        return altAssignt;
    }

    public void toXML(List<AlternativesAssignments<VALUE_TYPE>> list, XMLStreamWriter writer) throws XMLStreamException {
        if (list == null || list.size() == 0) {
            return;
        }
        for (AlternativesAssignments<VALUE_TYPE> alternativesAssignments : list) {
            this.toXML(alternativesAssignments, writer);
        }
    }

    public void toXML(AlternativesAssignments<VALUE_TYPE> alternativesAssignements, XMLStreamWriter writer) throws XMLStreamException {
        if (alternativesAssignements == null) {
            return;
        }
        writer.writeStartElement(ALTERNATIVES_ASSIGNMENTS);
        new CommonAttributesParser().toXML(alternativesAssignements, writer);
        writer.writeln();
        new DescriptionParser().toXML(alternativesAssignements.getDescription(), writer);
        for (AlternativeAssignment alternativeAssignment : alternativesAssignements) {
            this.toXML(alternativeAssignment, writer);
        }
        writer.writeEndElement();
        writer.writeln();
    }

    public void toXML(AlternativeAssignment<VALUE_TYPE> alternativeAssignement, XMLStreamWriter writer) throws XMLStreamException {
        if (alternativeAssignement == null) {
            return;
        }
        writer.writeStartElement(ALTERNATIVE_ASSIGNMENT);
        new CommonAttributesParser().toXML(alternativeAssignement, writer);
        writer.writeln();
        new DescriptionParser().toXML(alternativeAssignement.getDescription(), writer);
        if (alternativeAssignement.getAlternative() != null) {
            writer.writeElementChars(ALTERNATIVE_ID, alternativeAssignement.getAlternative().id());
        }
        if (alternativeAssignement.getCategory() != null) {
            writer.writeElementChars(CATEGORY_ID, alternativeAssignement.getCategory().id());
        } else if (alternativeAssignement.getCategoriesSet() != null) {
            writer.writeElementChars(CATEGORIES_SET_ID, alternativeAssignement.getCategoriesSet().id());
        } else if (alternativeAssignement.getCategoryInterval() != null) {
            new CategoriesIntervalParser().toXML(alternativeAssignement.getCategoryInterval(), writer);
        }
        if (alternativeAssignement.getValues() != null) {
            new QualifiedValuesParser<VALUE_TYPE>().toXML(alternativeAssignement.getValues(), writer);
        }
        writer.writeEndElement();
        writer.writeln();
    }
}

