/*
 * Decompiled with CFR 0.152.
 */
package org.xmcda.parsers.xml.xmcda_v3;

import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.xmcda.Alternative;
import org.xmcda.AlternativesValues;
import org.xmcda.Factory;
import org.xmcda.LabelledQValues;
import org.xmcda.XMCDA;
import org.xmcda.parsers.xml.xmcda_v3.CommonAttributesParser;
import org.xmcda.parsers.xml.xmcda_v3.DescriptionParser;
import org.xmcda.parsers.xml.xmcda_v3.QualifiedValuesParser;
import org.xmcda.parsers.xml.xmcda_v3.Utils;
import org.xmcda.parsers.xml.xmcda_v3.XMLStreamWriter;

public class AlternativeValuesParser<VALUE_TYPE> {
    public static final String ALTERNATIVE_VALUE = "alternativeValue";
    public static final String ALTERNATIVE_ID = "alternativeID";

    public Alternative fromXML(XMCDA xmcda, AlternativesValues<VALUE_TYPE> objectsValues, StartElement startElement, XMLEventReader eventReader) throws XMLStreamException {
        XMLEvent event;
        LabelledQValues alternativeValues = Factory.labelledQValues();
        new CommonAttributesParser().handleAttributes(alternativeValues, startElement);
        Alternative alternative = null;
        while (!(!eventReader.hasNext() || (event = eventReader.nextEvent()).isEndElement() && ALTERNATIVE_VALUE.equals(event.asEndElement().getName().getLocalPart()))) {
            if (!event.isStartElement()) continue;
            startElement = event.asStartElement();
            if ("description".equals(startElement.getName().getLocalPart())) {
                alternativeValues.setDescription(new DescriptionParser().fromXML(xmcda, startElement, eventReader));
            }
            if ("values".equals(startElement.asStartElement().getName().getLocalPart())) {
                alternativeValues.addAll(new QualifiedValuesParser().fromXML(xmcda, startElement, eventReader));
            }
            if (!ALTERNATIVE_ID.equals(startElement.getName().getLocalPart())) continue;
            String id = Utils.getTextContent(startElement, eventReader);
            alternative = (Alternative)xmcda.alternatives.get(id);
        }
        objectsValues.put(alternative, alternativeValues);
        return alternative;
    }

    public void toXML(Alternative alternative, LabelledQValues<VALUE_TYPE> alternativeValues, XMLStreamWriter writer) throws XMLStreamException {
        if (alternativeValues == null) {
            return;
        }
        writer.writeStartElement(ALTERNATIVE_VALUE);
        new CommonAttributesParser().toXML(alternativeValues, writer);
        writer.writeln();
        new DescriptionParser().toXML(alternativeValues.getDescription(), writer);
        writer.writeElementChars(ALTERNATIVE_ID, alternative.id());
        new QualifiedValuesParser<VALUE_TYPE>().toXML(alternativeValues, writer);
        writer.writeEndElement();
        writer.writeln();
    }
}

