/*
 * Decompiled with CFR 0.152.
 */
package org.xmcda.parsers.xml.xmcda_v2;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.xmcda.parsers.xml.xmcda_v2.XMCDA_v2_VERSION;

public class XMCDAv2OutputStream
extends BufferedOutputStream {
    public static final String XMCDA_LIB_WRITES_V2_VERSION = "XMCDA_lib_writes_v2_VERSION";
    private static XMCDA_v2_VERSION default_XMCDA_v2_version = XMCDA_v2_VERSION.XMCDA_2_2_2;
    private XMCDA_v2_VERSION XMCDA_v2_version = default_XMCDA_v2_version;

    public static XMCDA_v2_VERSION getDefaultXMCDA_v2_VERSION() {
        return default_XMCDA_v2_version;
    }

    public static void setDefaultXMCDA_v2_VERSION(XMCDA_v2_VERSION version) {
        if (version == null) {
            throw new NullPointerException("Parameter 'version' cannot be null");
        }
        default_XMCDA_v2_version = version;
    }

    public XMCDAv2OutputStream(OutputStream out) {
        super(out);
    }

    public XMCDAv2OutputStream(OutputStream out, int size) {
        super(out, size < 8192 ? 8192 : size);
    }

    @Override
    public synchronized void write(int b) throws IOException {
        super.write(b);
    }

    @Override
    public void write(byte[] b) throws IOException {
        super.write(b);
    }

    public XMCDA_v2_VERSION getXMCDAVersion() {
        return this.XMCDA_v2_version;
    }

    public void setXMCDAVersion(XMCDA_v2_VERSION XMCDA_v2_version) {
        if (XMCDA_v2_version == null) {
            throw new NullPointerException("Parameter 'XMCDA_v2_version' cannot be null");
        }
        this.XMCDA_v2_version = XMCDA_v2_version;
    }

    @Override
    public synchronized void write(byte[] b, int off, int len) throws IOException {
        String s = new String(b, off, len);
        s = s.replace(XMCDA_v2_VERSION.get((String)"2.2.2").namespace, this.XMCDA_v2_version.namespace);
        byte[] c = s.getBytes();
        super.write(c, 0, c.length);
    }

    static {
        String sys_env_v2 = System.getenv().getOrDefault(XMCDA_LIB_WRITES_V2_VERSION, null);
        XMCDA_v2_VERSION env_version = null;
        if (sys_env_v2 != null) {
            // empty if block
        }
        if ((env_version = XMCDA_v2_VERSION.get(sys_env_v2)) != null) {
            default_XMCDA_v2_version = env_version;
        }
    }
}

