/*
 * Decompiled with CFR 0.152.
 */
package org.xmcda.converters.v2_v3;

import org.xmcda.Factory;
import org.xmcda.QualifiedValue;
import org.xmcda.Threshold;
import org.xmcda.XMCDA;
import org.xmcda.converters.v2_v3.Converter;
import org.xmcda.converters.v2_v3.FunctionConverter;
import org.xmcda.converters.v2_v3.QualifiedValueConverter;
import org.xmcda.converters.v2_v3.V2ValueToNumericValueConverter;
import org.xmcda.v2.Function;
import org.xmcda.value.AffineFunction;
import org.xmcda.value.ConstantFunction;

public class ThresholdConverter
extends Converter {
    public static String THRESHOLD = "threshold";

    public ThresholdConverter() {
        super(THRESHOLD);
    }

    public Threshold convertTo_v3(Function threshold_v2, XMCDA xmcda_v3) {
        Threshold threshold_v3;
        this.getWarnings().pushTag(THRESHOLD, threshold_v2.getId());
        org.xmcda.value.Function function_v3 = new FunctionConverter().convertTo_v3(threshold_v2, xmcda_v3);
        if (function_v3 instanceof ConstantFunction) {
            ConstantFunction const_v3 = (ConstantFunction)function_v3;
            threshold_v3 = Factory.threshold(new QualifiedValue(const_v3.getValue()));
            threshold_v3.setId(threshold_v2.getId());
            threshold_v3.setName(threshold_v2.getName());
            threshold_v3.setMcdaConcept(threshold_v2.getMcdaConcept());
        } else if (function_v3 instanceof AffineFunction) {
            AffineFunction affine_v3 = (AffineFunction)function_v3;
            threshold_v3 = Factory.threshold(new QualifiedValue(affine_v3.getSlope()), new QualifiedValue(affine_v3.getIntercept()));
            threshold_v3.setId(threshold_v2.getId());
            threshold_v3.setName(threshold_v2.getName());
            threshold_v3.setMcdaConcept(threshold_v2.getMcdaConcept());
        } else {
            throw new RuntimeException("threshold can only contain a constant or affine function");
        }
        this.getWarnings().popTag();
        return threshold_v3;
    }

    public Function convertTo_v2(Threshold threshold_v3) {
        this.getWarnings().pushTag(THRESHOLD, threshold_v3.id());
        Function func_v2 = new Function();
        func_v2.setId(threshold_v3.id());
        func_v2.setName(threshold_v3.name());
        func_v2.setMcdaConcept(threshold_v3.mcdaConcept());
        if (threshold_v3.isConstant()) {
            func_v2.setConstant(V2ValueToNumericValueConverter.convert(new QualifiedValueConverter().convertTo_v2(threshold_v3.getConstant())));
        } else {
            Function.Linear linear_v2 = new Function.Linear();
            new V2ValueToNumericValueConverter();
            linear_v2.setIntercept(V2ValueToNumericValueConverter.convert(new QualifiedValueConverter().convertTo_v2(threshold_v3.getIntercept())));
            linear_v2.setSlope(V2ValueToNumericValueConverter.convert(new QualifiedValueConverter().convertTo_v2(threshold_v3.getSlope())));
            func_v2.setLinear(linear_v2);
        }
        this.getWarnings().popTag();
        return func_v2;
    }
}

