/*
 * Decompiled with CFR 0.152.
 */
package org.xmcda.converters.v2_v3;

import org.xmcda.Factory;
import org.xmcda.NominalScale;
import org.xmcda.QualitativeScale;
import org.xmcda.QuantitativeScale;
import org.xmcda.Scale;
import org.xmcda.XMCDA;
import org.xmcda.converters.v2_v3.Converter;
import org.xmcda.converters.v2_v3.FuzzyLabelConverter;
import org.xmcda.converters.v2_v3.PreferenceDirectionConverter;
import org.xmcda.converters.v2_v3.QualifiedValueConverter;
import org.xmcda.converters.v2_v3.RankedLabelConverter;
import org.xmcda.converters.v2_v3.V2ValueToNumericValueConverter;
import org.xmcda.v2.FuzzyLabel;
import org.xmcda.v2.Nominal;
import org.xmcda.v2.NumericValue;
import org.xmcda.v2.Qualitative;
import org.xmcda.v2.Quantitative;
import org.xmcda.v2.RankedLabel;
import org.xmcda.v2.Value;
import org.xmcda.value.FuzzyNumber;
import org.xmcda.value.ValuedLabel;

public class ScaleConverter
extends Converter {
    public static final String SCALE = "scale";

    public ScaleConverter() {
        super(SCALE);
    }

    public Scale convertTo_v3(org.xmcda.v2.Scale scale_v2, XMCDA xmcda_v3) {
        if (scale_v2 == null) {
            return null;
        }
        String id = scale_v2.getId();
        this.getWarnings().pushTag(SCALE, id);
        Scale scale_v3 = null;
        if (scale_v2.getNominal() != null) {
            scale_v3 = new NominalScaleConverter().convertTo_v3(scale_v2);
        } else if (scale_v2.getQualitative() != null) {
            scale_v3 = new QualitativeScaleConverter().convertTo_v3(scale_v2, xmcda_v3);
        } else if (scale_v2.getQuantitative() != null) {
            scale_v3 = new QuantitativeScaleConverter().convertTo_v3(scale_v2, xmcda_v3);
        }
        scale_v3.setId(scale_v2.getId());
        scale_v3.setName(scale_v2.getName());
        scale_v3.setMcdaConcept(scale_v2.getMcdaConcept());
        if (scale_v2.getDescription() != null) {
            this.getWarnings().elementIgnored("description");
        }
        if (scale_v2.getValuationType() != null) {
            this.getWarnings().elementIgnored("valuationType");
        }
        this.getWarnings().popTag();
        return scale_v3;
    }

    public org.xmcda.v2.Scale convertTo_v2(Scale scale_v3) {
        if (scale_v3 == null) {
            return null;
        }
        String id = scale_v3.id();
        this.getWarnings().pushTag(SCALE, id);
        org.xmcda.v2.Scale scale_v2 = null;
        if (scale_v3 instanceof NominalScale) {
            scale_v2 = new NominalScaleConverter().convertTo_v2((NominalScale)scale_v3);
        } else if (scale_v3 instanceof QualitativeScale) {
            scale_v2 = new QualitativeScaleConverter().convertTo_v2((QualitativeScale)scale_v3);
        } else if (scale_v3 instanceof QuantitativeScale) {
            scale_v2 = new QuantitativeScaleConverter().convertTo_v2((QuantitativeScale)scale_v3);
        }
        scale_v2.setId(scale_v3.id());
        scale_v2.setName(scale_v3.name());
        scale_v2.setMcdaConcept(scale_v3.mcdaConcept());
        this.getWarnings().popTag();
        return scale_v2;
    }

    protected static class QuantitativeScaleConverter
    extends Converter {
        public QuantitativeScaleConverter() {
            super(ScaleConverter.SCALE);
        }

        public Scale convertTo_v3(org.xmcda.v2.Scale scale_v2, XMCDA xmcda_v3) {
            QuantitativeScale scale_v3;
            QuantitativeScale quantitativeScale_v3 = scale_v3 = Factory.quantitativeScale();
            quantitativeScale_v3.setPreferenceDirection(new PreferenceDirectionConverter().convertTo_v3(scale_v2.getQuantitative().getPreferenceDirection()));
            if (scale_v2.getQuantitative().getMinimum() != null) {
                quantitativeScale_v3.setMinimum(new QualifiedValueConverter().convertTo_v3(scale_v2.getQuantitative().getMinimum(), xmcda_v3));
            }
            if (scale_v2.getQuantitative().getMaximum() != null) {
                quantitativeScale_v3.setMaximum(new QualifiedValueConverter().convertTo_v3(scale_v2.getQuantitative().getMaximum(), xmcda_v3));
            }
            return scale_v3;
        }

        public org.xmcda.v2.Scale convertTo_v2(Scale scale_v3) {
            NumericValue _nValue;
            Value _value;
            org.xmcda.v2.Scale scale_v2 = new org.xmcda.v2.Scale();
            QuantitativeScale quantitativeScale_v3 = (QuantitativeScale)scale_v3;
            Quantitative quantitative_v2 = new Quantitative();
            scale_v2.setQuantitative(quantitative_v2);
            quantitative_v2.setPreferenceDirection(new PreferenceDirectionConverter().convertTo_v2(quantitativeScale_v3.getPreferenceDirection()));
            if (quantitativeScale_v3.getMinimum() != null) {
                _value = new QualifiedValueConverter().convertTo_v2(quantitativeScale_v3.getMinimum());
                _nValue = V2ValueToNumericValueConverter.convert(_value);
                quantitative_v2.setMinimum(_nValue);
            }
            if (quantitativeScale_v3.getMaximum() != null) {
                _value = new QualifiedValueConverter().convertTo_v2(quantitativeScale_v3.getMaximum());
                _nValue = V2ValueToNumericValueConverter.convert(_value);
                quantitative_v2.setMaximum(_nValue);
            }
            return scale_v2;
        }
    }

    protected static class QualitativeScaleConverter
    extends Converter {
        public QualitativeScaleConverter() {
            super(ScaleConverter.SCALE);
        }

        public Scale convertTo_v3(org.xmcda.v2.Scale scale_v2, XMCDA xmcda_v3) {
            QualitativeScale scale_v3;
            this.getWarnings().pushTag(ScaleConverter.SCALE, scale_v2.getId());
            QualitativeScale qualitativeScale_v3 = scale_v3 = Factory.qualitativeScale();
            Qualitative qualitative_v2 = scale_v2.getQualitative();
            if (scale_v2.getDescription() != null) {
                this.getWarnings().elementIgnored("description");
            }
            qualitativeScale_v3.setPreferenceDirection(new PreferenceDirectionConverter().convertTo_v3(qualitative_v2.getPreferenceDirection()));
            for (RankedLabel rankedLabel_v2 : qualitative_v2.getRankedLabel()) {
                qualitativeScale_v3.add(new RankedLabelConverter().convertTo_v3(rankedLabel_v2));
            }
            for (FuzzyLabel fuzzyLabel_v2 : qualitative_v2.getFuzzyLabel()) {
                qualitativeScale_v3.add(new FuzzyLabelConverter().convertTo_v3(fuzzyLabel_v2, xmcda_v3));
            }
            this.getWarnings().popTag();
            return scale_v3;
        }

        public org.xmcda.v2.Scale convertTo_v2(QualitativeScale<?> scale_v3) {
            this.getWarnings().pushTag(ScaleConverter.SCALE, scale_v3.id());
            org.xmcda.v2.Scale scale_v2 = new org.xmcda.v2.Scale();
            Qualitative qualitative_v2 = new Qualitative();
            scale_v2.setQualitative(qualitative_v2);
            qualitative_v2.setPreferenceDirection(new PreferenceDirectionConverter().convertTo_v2(scale_v3.getPreferenceDirection()));
            for (ValuedLabel valuedLabel : scale_v3) {
                if (valuedLabel.getValue().getValue() instanceof FuzzyNumber) {
                    qualitative_v2.getFuzzyLabel().add(new FuzzyLabelConverter().convertTo_v2(valuedLabel));
                    continue;
                }
                qualitative_v2.getRankedLabel().add(new RankedLabelConverter().convertTo_v2(valuedLabel));
            }
            this.getWarnings().popTag();
            return scale_v2;
        }
    }

    protected static class NominalScaleConverter
    extends Converter {
        public NominalScaleConverter() {
            super(ScaleConverter.SCALE);
        }

        public Scale convertTo_v3(org.xmcda.v2.Scale scale_v2) {
            NominalScale scale_v3 = Factory.nominalScale();
            Nominal nominal_v2 = scale_v2.getNominal();
            for (String label : nominal_v2.getLabel()) {
                scale_v3.add(label);
            }
            return scale_v3;
        }

        public org.xmcda.v2.Scale convertTo_v2(NominalScale scale_v3) {
            org.xmcda.v2.Scale scale_v2 = new org.xmcda.v2.Scale();
            scale_v2.setNominal(new Nominal());
            for (String label : scale_v3) {
                scale_v2.getNominal().getLabel().add(label);
            }
            return scale_v2;
        }
    }
}

