/*
 * Decompiled with CFR 0.152.
 */
package org.xmcda.converters.v2_v3;

import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import org.xmcda.Alternative;
import org.xmcda.Criterion;
import org.xmcda.PerformanceTable;
import org.xmcda.QualifiedValue;
import org.xmcda.QualifiedValues;
import org.xmcda.XMCDA;
import org.xmcda.converters.v2_v3.Converter;
import org.xmcda.converters.v2_v3.DescriptionConverter;
import org.xmcda.converters.v2_v3.QualifiedValueConverter;
import org.xmcda.utils.PerformanceTableCoord;
import org.xmcda.v2.AlternativeOnCriteriaPerformances;

public class PerformanceTableConverter
extends Converter {
    public static final String PERFORMANCE_TABLE = "performanceTable";

    public PerformanceTableConverter() {
        super(PERFORMANCE_TABLE);
    }

    public <T> void convertTo_v3(org.xmcda.v2.PerformanceTable perfTable_v2, XMCDA xmcda_v3) {
        String id = perfTable_v2.getId();
        this.getWarnings().pushTag(PERFORMANCE_TABLE, id);
        PerformanceTable perfTable_v3 = new PerformanceTable();
        perfTable_v3.setName(perfTable_v2.getName());
        perfTable_v3.setMcdaConcept(perfTable_v2.getMcdaConcept());
        xmcda_v3.performanceTablesList.add(perfTable_v3);
        perfTable_v3.setDescription(new DescriptionConverter().convertTo_v3(perfTable_v2.getDescription()));
        if (perfTable_v2.getDescription() != null && perfTable_v2.getDescription().getTitle() != null && perfTable_v3.name() == null) {
            perfTable_v3.setName(perfTable_v2.getDescription().getTitle());
        }
        for (AlternativeOnCriteriaPerformances row : perfTable_v2.getAlternativePerformances()) {
            String alternativeID = row.getAlternativeID();
            this.getWarnings().pushTag("alternativesPerformances", alternativeID);
            if (row.getDescription() != null) {
                this.getWarnings().elementIgnored("description", "Concept does not exist in XMCDA v3");
            }
            if (row.getId() != null && row.getId().length() > 0) {
                this.getWarnings().attributeIgnored("id");
            }
            if (row.getName() != null && row.getName().length() > 0) {
                this.getWarnings().attributeIgnored("name");
            }
            if (row.getMcdaConcept() != null && row.getMcdaConcept().length() > 0) {
                this.getWarnings().attributeIgnored("mcdaConcept");
            }
            for (AlternativeOnCriteriaPerformances.Performance cell : row.getPerformance()) {
                String criterionID = cell.getCriterionID();
                this.getWarnings().pushTag("performance", criterionID);
                if (cell.getAttributeID() != null) {
                    this.getWarnings().elementIgnored("attributeID");
                    continue;
                }
                QualifiedValue value = new QualifiedValueConverter().convertTo_v3(cell.getValue(), xmcda_v3);
                perfTable_v3.put((Alternative)xmcda_v3.alternatives.get(alternativeID), (Criterion)xmcda_v3.criteria.get(criterionID), value);
                this.getWarnings().popTag();
            }
            this.getWarnings().popTag();
        }
        this.getWarnings().popTag();
    }

    public void convertTo_v2(List<PerformanceTable<?>> perfTables_v3, org.xmcda.v2.XMCDA xmcda_v2) {
        for (PerformanceTable<?> perfTable_v3 : perfTables_v3) {
            org.xmcda.v2.PerformanceTable perfTable_v2 = this.convertTo_v2(perfTable_v3, xmcda_v2);
            List<JAXBElement<?>> perfTables_v2 = xmcda_v2.getProjectReferenceOrMethodMessagesOrMethodParameters();
            perfTables_v2.add(new JAXBElement(new QName(PERFORMANCE_TABLE), org.xmcda.v2.PerformanceTable.class, (Object)perfTable_v2));
        }
    }

    public <T> org.xmcda.v2.PerformanceTable convertTo_v2(PerformanceTable<T> perfTable_v3, org.xmcda.v2.XMCDA xmcda_v2) {
        this.getWarnings().pushTag(PERFORMANCE_TABLE, perfTable_v3.id());
        org.xmcda.v2.PerformanceTable perfTable_v2 = new org.xmcda.v2.PerformanceTable();
        perfTable_v2.setId(perfTable_v3.id());
        perfTable_v2.setName(perfTable_v3.name());
        perfTable_v2.setMcdaConcept(perfTable_v3.mcdaConcept());
        perfTable_v2.setDescription(new DescriptionConverter().convertTo_v2(perfTable_v3.getDescription()));
        for (Map.Entry entry : perfTable_v3.entrySet()) {
            QualifiedValues values_v3 = (QualifiedValues)entry.getValue();
            if (values_v3 == null || values_v3.size() == 0) continue;
            if (values_v3.size() > 1) {
                throw new RuntimeException("more than one value in a performance table");
            }
            String alternativeID = ((Alternative)((PerformanceTableCoord)entry.getKey()).x).id();
            this.getWarnings().pushTag("alternativesPerformances", alternativeID);
            AlternativeOnCriteriaPerformances row_v2 = this.getRow_v2(perfTable_v2, alternativeID);
            AlternativeOnCriteriaPerformances.Performance cell_v2 = new AlternativeOnCriteriaPerformances.Performance();
            String criterionID = ((Criterion)((PerformanceTableCoord)entry.getKey()).y).id();
            this.getWarnings().pushTag("performance", criterionID);
            cell_v2.setCriterionID(criterionID);
            cell_v2.setValue(new QualifiedValueConverter().convertTo_v2((QualifiedValue)values_v3.get(0)));
            row_v2.getPerformance().add(cell_v2);
            this.getWarnings().popTag();
            this.getWarnings().popTag();
        }
        this.getWarnings().popTag();
        return perfTable_v2;
    }

    private AlternativeOnCriteriaPerformances getRow_v2(org.xmcda.v2.PerformanceTable pv2, String alternativeID) {
        for (AlternativeOnCriteriaPerformances row : pv2.getAlternativePerformances()) {
            if (!alternativeID.equals(row.getAlternativeID())) continue;
            return row;
        }
        AlternativeOnCriteriaPerformances row = new AlternativeOnCriteriaPerformances();
        row.setAlternativeID(alternativeID);
        pv2.getAlternativePerformances().add(row);
        return row;
    }
}

