/*
 * Decompiled with CFR 0.152.
 */
package org.xmcda.converters.v2_v3;

import java.util.GregorianCalendar;
import java.util.List;
import javax.xml.bind.JAXBElement;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import org.xmcda.Description;
import org.xmcda.Factory;
import org.xmcda.converters.v2_v3.BibliographyConverter;
import org.xmcda.converters.v2_v3.Converter;
import org.xmcda.v2.Bibliography;

public class DescriptionConverter
extends Converter {
    public static final String DESCRIPTION = "description";
    public static final String AUTHOR = "author";
    public static final String COMMENT = "comment";
    public static final String KEYWORDS = "keywords";
    public static final String CREATION_DATE = "creationDate";
    public static final String LAST_MODIFICATION_DATE = "lastModificationDate";

    public DescriptionConverter() {
        super(DESCRIPTION);
    }

    public Description convertTo_v3(org.xmcda.v2.Description description) {
        if (description == null) {
            return null;
        }
        this.getWarnings().pushTag(DESCRIPTION);
        Description description_v3 = Factory.description();
        if (description.getTitle() != null) {
            this.getWarnings().elementIgnored("title");
        }
        if (description.getSubTitle() != null) {
            this.getWarnings().elementIgnored("subTitle");
        }
        if (description.getSubSubTitle() != null) {
            this.getWarnings().elementIgnored("subSubTitle");
        }
        for (JAXBElement<?> element : description.getUserOrAuthorOrVersion()) {
            String currentName = element.getName().getLocalPart();
            Object value = element.getValue();
            if (value == null) continue;
            if (COMMENT.equals(currentName)) {
                description_v3.setComment((String)value);
                continue;
            }
            if (AUTHOR.equals(currentName)) {
                description_v3.getAuthors().add((String)value);
                continue;
            }
            if (CREATION_DATE.equals(currentName)) {
                description_v3.setCreationDate(((XMLGregorianCalendar)value).toGregorianCalendar());
                continue;
            }
            if (LAST_MODIFICATION_DATE.equals(currentName)) {
                description_v3.setLastModificationDate(((XMLGregorianCalendar)value).toGregorianCalendar());
                continue;
            }
            if (KEYWORDS.equals(currentName)) {
                for (String kw : ((String)value).split(",")) {
                    description_v3.getKeywords().add(kw.trim());
                }
                continue;
            }
            if ("bibliography".equals(currentName)) {
                description_v3.setBibliography(new BibliographyConverter().convertTo_v3((Bibliography)value));
                continue;
            }
            this.getWarnings().elementIgnored(currentName);
        }
        this.getWarnings().popTag();
        return description_v3;
    }

    public org.xmcda.v2.Description convertTo_v2(Description description_v3) {
        DatatypeFactory dtf;
        if (description_v3 == null) {
            return null;
        }
        try {
            dtf = DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException e) {
            return null;
        }
        this.getWarnings().pushTag(DESCRIPTION);
        org.xmcda.v2.Description description_v2 = new org.xmcda.v2.Description();
        List<JAXBElement<?>> list_v2 = description_v2.getUserOrAuthorOrVersion();
        for (String string : description_v3.getAuthors()) {
            list_v2.add(new JAXBElement(new QName(AUTHOR), String.class, (Object)string));
        }
        if (description_v3.getComment() != null) {
            list_v2.add(new JAXBElement(new QName(COMMENT), String.class, (Object)description_v3.getComment()));
        }
        if (description_v3.getKeywords() != null && description_v3.getKeywords().size() > 0) {
            StringBuffer kws = new StringBuffer();
            for (String keyword : description_v3.getKeywords()) {
                kws.append(keyword).append(",");
            }
            String string = kws.substring(0, kws.length() - 1);
            list_v2.add(new JAXBElement(new QName(KEYWORDS), String.class, (Object)string));
        }
        if (description_v3.getCreationDate() != null) {
            XMLGregorianCalendar _creationDate = dtf.newXMLGregorianCalendar(description_v3.getCreationDate());
            list_v2.add(new JAXBElement(new QName(CREATION_DATE), XMLGregorianCalendar.class, (Object)_creationDate));
        }
        if (description_v3.getLastModificationDate() != null) {
            GregorianCalendar _date = description_v3.getLastModificationDate();
            XMLGregorianCalendar xMLGregorianCalendar = dtf.newXMLGregorianCalendar(_date);
            list_v2.add(new JAXBElement(new QName(LAST_MODIFICATION_DATE), XMLGregorianCalendar.class, (Object)xMLGregorianCalendar));
        }
        if (description_v3.getBibliography() != null) {
            Bibliography bib_v2 = new BibliographyConverter().convertTo_v2(description_v3.getBibliography());
            list_v2.add(new JAXBElement(new QName("bibliography"), Bibliography.class, (Object)bib_v2));
        }
        this.getWarnings().popTag();
        return description_v2;
    }
}

