/*
 * Decompiled with CFR 0.152.
 */
package org.xmcda.converters.v2_v3;

import java.util.List;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import org.xmcda.CriteriaMatrix;
import org.xmcda.CriteriaSet;
import org.xmcda.CriteriaSetsMatrix;
import org.xmcda.Criterion;
import org.xmcda.Factory;
import org.xmcda.QualifiedValue;
import org.xmcda.QualifiedValues;
import org.xmcda.XMCDA;
import org.xmcda.converters.v2_v3.Converter;
import org.xmcda.converters.v2_v3.CriteriaSetConverter;
import org.xmcda.converters.v2_v3.DescriptionConverter;
import org.xmcda.converters.v2_v3.QualifiedValueConverter;
import org.xmcda.converters.v2_v3.ScaleConverter;
import org.xmcda.utils.Coord;
import org.xmcda.v2.CriteriaComparisons;
import org.xmcda.v2.CriterionReference;
import org.xmcda.v2.Value;
import org.xmcda.v2.Values;
import org.xmcda.value.NA;

public class CriteriaComparisonsConverter
extends Converter {
    public static final String CRITERIA_COMPARISONS = "criteriaComparisons";
    public static final String PAIRS = "pairs";
    public static final String PAIR = "pair";

    public CriteriaComparisonsConverter() {
        super(CRITERIA_COMPARISONS);
    }

    public void convertTo_v3(CriteriaComparisons value, XMCDA xmcda_v3) {
        CriteriaComparisons.Pairs pairs = value.getPairs();
        if (pairs == null || pairs.getPair().size() == 0) {
            this.convertCriteriaComparisonsTo_v3(value, xmcda_v3);
            return;
        }
        CriteriaComparisons.Pairs.Pair pair = pairs.getPair().get(0);
        String initial_id = pair.getInitial().getCriterionID();
        if (initial_id != null) {
            this.convertCriteriaComparisonsTo_v3(value, xmcda_v3);
        } else {
            this.convertCriteriaSetsComparisonsTo_v3(value, xmcda_v3);
        }
    }

    public void convertCriteriaSetsComparisonsTo_v3(CriteriaComparisons value, XMCDA xmcda_v3) {
        CriteriaComparisons.Pairs pairs;
        this.getWarnings().pushTag(CRITERIA_COMPARISONS, value.getId());
        CriteriaSetsMatrix criteriaSetsMatrix_v3 = Factory.criteriaSetsMatrix();
        criteriaSetsMatrix_v3.setId(value.getId());
        criteriaSetsMatrix_v3.setMcdaConcept(value.getMcdaConcept());
        criteriaSetsMatrix_v3.setName(value.getName());
        criteriaSetsMatrix_v3.setDescription(new DescriptionConverter().convertTo_v3(value.getDescription()));
        if (value.getValuation() != null) {
            criteriaSetsMatrix_v3.setValuation(new ScaleConverter().convertTo_v3(value.getValuation(), xmcda_v3));
        }
        if (value.getPairs().getDescription() != null) {
            this.getWarnings().elementIgnored("description", "Concept does not exist in XMCDA v3");
        }
        if ((pairs = value.getPairs()) == null || pairs.getPair().size() == 0) {
            this.getWarnings().elementUnimplemented("empty v2");
            return;
        }
        this.getWarnings().pushTag(PAIRS, value.getId());
        String comparisonType = value.getComparisonType();
        if (comparisonType != null && !"".equals(comparisonType)) {
            this.getWarnings().elementIgnored("comparisonType");
        }
        for (CriteriaComparisons.Pairs.Pair pair : pairs.getPair()) {
            CriteriaSet initial = null;
            String initial_id = pair.getInitial().getCriterionID();
            String initial_set_id = pair.getInitial().getCriteriaSetID();
            org.xmcda.v2.CriteriaSet initial_set = pair.getInitial().getCriteriaSet();
            if (initial_id != null) {
                throw new IllegalArgumentException("criterionID unexpected");
            }
            if (initial_set_id != null) {
                initial = (CriteriaSet)xmcda_v3.criteriaSets.get(initial_set_id, true);
            } else if (initial_set != null) {
                initial = new CriteriaSetConverter().convertTo_v3(initial_set, xmcda_v3);
                xmcda_v3.criteriaSets.add(initial);
            } else {
                throw new IllegalArgumentException("Invalid pair, no criteriaSetID nor criteriaSet in initial");
            }
            CriteriaSet terminal = null;
            String terminal_id = pair.getTerminal().getCriterionID();
            String terminal_set_id = pair.getTerminal().getCriteriaSetID();
            org.xmcda.v2.CriteriaSet terminal_set = pair.getTerminal().getCriteriaSet();
            if (terminal_id != null) {
                throw new IllegalArgumentException("criterionID unexpected");
            }
            if (terminal_set_id != null) {
                terminal = (CriteriaSet)xmcda_v3.criteriaSets.get(terminal_set_id, true);
            } else if (terminal_set != null) {
                terminal = new CriteriaSetConverter().convertTo_v3(terminal_set, xmcda_v3);
                xmcda_v3.criteriaSets.add(terminal);
            } else {
                throw new IllegalArgumentException("Invalid pair, no criteriaSetID nor criteriaSet in initial");
            }
            List<Object> pairValue_v2 = pair.getValueOrValues();
            QualifiedValues values_v3 = Factory.qualifiedValues();
            if (pairValue_v2 == null || pairValue_v2.size() == 0) {
                QualifiedValue<NA> tmpValue = Factory.qualifiedValue();
                tmpValue.setValue(NA.na);
                values_v3.add(tmpValue);
            } else {
                for (Object valueOrValues : pairValue_v2) {
                    if (valueOrValues instanceof Value) {
                        Value tmpValue_v2 = (Value)valueOrValues;
                        values_v3.add(new QualifiedValueConverter().convertTo_v3(tmpValue_v2, xmcda_v3));
                        continue;
                    }
                    Values tmpValues_v2 = (Values)valueOrValues;
                    for (Value tmpValue_v2 : tmpValues_v2.getValue()) {
                        values_v3.add(new QualifiedValueConverter().convertTo_v3(tmpValue_v2, xmcda_v3));
                    }
                }
            }
            criteriaSetsMatrix_v3.put(new Coord<CriteriaSet, CriteriaSet>(initial, terminal), values_v3);
        }
        this.getWarnings().popTag();
        this.getWarnings().popTag();
        xmcda_v3.criteriaSetsMatricesList.add(criteriaSetsMatrix_v3);
    }

    public void convertCriteriaComparisonsTo_v3(CriteriaComparisons value, XMCDA xmcda_v3) {
        CriteriaComparisons.Pairs pairs;
        this.getWarnings().pushTag(CRITERIA_COMPARISONS, value.getId());
        CriteriaMatrix criteriaMatrix_v3 = Factory.criteriaMatrix();
        criteriaMatrix_v3.setId(value.getId());
        criteriaMatrix_v3.setMcdaConcept(value.getMcdaConcept());
        criteriaMatrix_v3.setName(value.getName());
        criteriaMatrix_v3.setDescription(new DescriptionConverter().convertTo_v3(value.getDescription()));
        if (value.getValuation() != null) {
            criteriaMatrix_v3.setValuation(new ScaleConverter().convertTo_v3(value.getValuation(), xmcda_v3));
        }
        if (value.getPairs().getDescription() != null) {
            this.getWarnings().elementIgnored("description", "Concept does not exist in XMCDA v3");
        }
        if ((pairs = value.getPairs()) == null || pairs.getPair().size() == 0) {
            this.getWarnings().elementUnimplemented("empty v2");
            return;
        }
        this.getWarnings().pushTag(PAIRS, value.getId());
        String comparisonType = value.getComparisonType();
        if (comparisonType != null && !"".equals(comparisonType)) {
            this.getWarnings().elementIgnored("comparisonType");
        }
        for (CriteriaComparisons.Pairs.Pair pair : pairs.getPair()) {
            Object initial = null;
            String initial_id = pair.getInitial().getCriterionID();
            String initial_set_id = pair.getInitial().getCriteriaSetID();
            org.xmcda.v2.CriteriaSet initial_set = pair.getInitial().getCriteriaSet();
            if (initial_id == null) {
                if (initial_set_id != null) {
                    throw new IllegalArgumentException("criteriaSetID unexpected");
                }
                if (initial_set != null) {
                    throw new IllegalArgumentException("criteriaSet unexpected");
                }
                throw new IllegalArgumentException("Invalid pair, no criteriaID in initial");
            }
            initial = xmcda_v3.criteria.get(initial_id, true);
            Object terminal = null;
            String terminal_id = pair.getTerminal().getCriterionID();
            String terminal_set_id = pair.getTerminal().getCriteriaSetID();
            org.xmcda.v2.CriteriaSet terminal_set = pair.getTerminal().getCriteriaSet();
            if (terminal_id == null) {
                if (terminal_set_id != null) {
                    throw new IllegalArgumentException("criteriaSetID unexpected");
                }
                if (terminal_set != null) {
                    throw new IllegalArgumentException("criteriaSet unexpected");
                }
                throw new IllegalArgumentException("Invalid pair, no criteriaID in terminal");
            }
            terminal = xmcda_v3.criteria.get(terminal_id, true);
            List<Object> pairValue_v2 = pair.getValueOrValues();
            QualifiedValues values_v3 = Factory.qualifiedValues();
            if (pairValue_v2 == null || pairValue_v2.size() == 0) {
                QualifiedValue<NA> tmpValue = Factory.qualifiedValue();
                tmpValue.setValue(NA.na);
                values_v3.add(tmpValue);
            } else {
                for (Object valueOrValues : pairValue_v2) {
                    if (valueOrValues instanceof Value) {
                        Value tmpValue_v2 = (Value)valueOrValues;
                        values_v3.add(new QualifiedValueConverter().convertTo_v3(tmpValue_v2, xmcda_v3));
                        continue;
                    }
                    Values tmpValues_v2 = (Values)valueOrValues;
                    for (Value tmpValue_v2 : tmpValues_v2.getValue()) {
                        values_v3.add(new QualifiedValueConverter().convertTo_v3(tmpValue_v2, xmcda_v3));
                    }
                }
            }
            criteriaMatrix_v3.put(new Coord<Object, Object>(initial, terminal), values_v3);
        }
        this.getWarnings().popTag();
        this.getWarnings().popTag();
        xmcda_v3.criteriaMatricesList.add(criteriaMatrix_v3);
    }

    public void convertCriteriaMatricesTo_v2(List<CriteriaMatrix<?>> criteriaMatrices_v3, org.xmcda.v2.XMCDA xmcda_v2) {
        for (CriteriaMatrix<?> criteriaMatrix_v3 : criteriaMatrices_v3) {
            this.convertCriteriaMatrixTo_v2(criteriaMatrix_v3, xmcda_v2);
        }
    }

    public void convertCriteriaMatrixTo_v2(CriteriaMatrix criteriaMatrix_v3, org.xmcda.v2.XMCDA xmcda_v2) {
        this.getWarnings().pushTag("criteriaMatrix");
        CriteriaComparisons criteriaComparisons_v2 = new CriteriaComparisons();
        List<JAXBElement<?>> ccs = xmcda_v2.getProjectReferenceOrMethodMessagesOrMethodParameters();
        ccs.add(new JAXBElement(new QName(CRITERIA_COMPARISONS), CriteriaComparisons.class, (Object)criteriaComparisons_v2));
        criteriaComparisons_v2.setId(criteriaMatrix_v3.id());
        criteriaComparisons_v2.setName(criteriaMatrix_v3.name());
        criteriaComparisons_v2.setMcdaConcept(criteriaMatrix_v3.mcdaConcept());
        criteriaComparisons_v2.setDescription(new DescriptionConverter().convertTo_v2(criteriaMatrix_v3.getDescription()));
        criteriaComparisons_v2.setValuation(new ScaleConverter().convertTo_v2(criteriaMatrix_v3.getValuation()));
        CriteriaComparisons.Pairs pairs_v2 = new CriteriaComparisons.Pairs();
        criteriaComparisons_v2.setPairs(pairs_v2);
        for (Object _coord : criteriaMatrix_v3.keySet()) {
            Coord coord = (Coord)_coord;
            CriteriaComparisons.Pairs.Pair pair_v2 = new CriteriaComparisons.Pairs.Pair();
            CriterionReference criterionRef_initial = new CriterionReference();
            criterionRef_initial.setCriterionID(((Criterion)coord.x).id());
            CriterionReference criterionRef_terminal = new CriterionReference();
            criterionRef_terminal.setCriterionID(((Criterion)coord.y).id());
            pair_v2.setInitial(criterionRef_initial);
            pair_v2.setTerminal(criterionRef_terminal);
            Values values_v2 = new Values();
            QualifiedValues values_v3 = (QualifiedValues)criteriaMatrix_v3.get(_coord);
            if (values_v3 != null) {
                for (Object _value : values_v3) {
                    QualifiedValue value = (QualifiedValue)_value;
                    Value value_v2 = new QualifiedValueConverter().convertTo_v2(value);
                    values_v2.getValue().add(value_v2);
                }
            }
            pair_v2.getValueOrValues().add(values_v2);
            pairs_v2.getPair().add(pair_v2);
        }
        this.getWarnings().popTag();
    }

    public void convertCriteriaSetsMatricesTo_v2(List<CriteriaSetsMatrix<?, ?>> criteriaSetsMatrices_v3, org.xmcda.v2.XMCDA xmcda_v2) {
        for (CriteriaSetsMatrix<?, ?> criteriaSetsMatrix_v3 : criteriaSetsMatrices_v3) {
            this.convertCriteriaSetsMatrixTo_v2(criteriaSetsMatrix_v3, xmcda_v2);
        }
    }

    public void convertCriteriaSetsMatrixTo_v2(CriteriaSetsMatrix criteriaSetsMatrix_v3, org.xmcda.v2.XMCDA xmcda_v2) {
        this.getWarnings().pushTag("criteriaMatrix");
        CriteriaComparisons criteriaComparisons_v2 = new CriteriaComparisons();
        List<JAXBElement<?>> ccs = xmcda_v2.getProjectReferenceOrMethodMessagesOrMethodParameters();
        ccs.add(new JAXBElement(new QName(CRITERIA_COMPARISONS), CriteriaComparisons.class, (Object)criteriaComparisons_v2));
        criteriaComparisons_v2.setId(criteriaSetsMatrix_v3.id());
        criteriaComparisons_v2.setName(criteriaSetsMatrix_v3.name());
        criteriaComparisons_v2.setMcdaConcept(criteriaSetsMatrix_v3.mcdaConcept());
        criteriaComparisons_v2.setDescription(new DescriptionConverter().convertTo_v2(criteriaSetsMatrix_v3.getDescription()));
        criteriaComparisons_v2.setValuation(new ScaleConverter().convertTo_v2(criteriaSetsMatrix_v3.getValuation()));
        CriteriaComparisons.Pairs pairs_v2 = new CriteriaComparisons.Pairs();
        criteriaComparisons_v2.setPairs(pairs_v2);
        for (Object _coord : criteriaSetsMatrix_v3.keySet()) {
            Coord coord = (Coord)_coord;
            CriteriaComparisons.Pairs.Pair pair_v2 = new CriteriaComparisons.Pairs.Pair();
            CriterionReference criterionRef_initial = new CriterionReference();
            criterionRef_initial.setCriteriaSetID(((CriteriaSet)coord.x).id());
            CriterionReference criterionRef_terminal = new CriterionReference();
            criterionRef_terminal.setCriteriaSetID(((CriteriaSet)coord.y).id());
            pair_v2.setInitial(criterionRef_initial);
            pair_v2.setTerminal(criterionRef_terminal);
            Values values_v2 = new Values();
            QualifiedValues values_v3 = (QualifiedValues)criteriaSetsMatrix_v3.get(_coord);
            if (values_v3 != null) {
                for (Object _value : values_v3) {
                    QualifiedValue value = (QualifiedValue)_value;
                    Value value_v2 = new QualifiedValueConverter().convertTo_v2(value);
                    values_v2.getValue().add(value_v2);
                }
            }
            pair_v2.getValueOrValues().add(values_v2);
            pairs_v2.getPair().add(pair_v2);
        }
        this.getWarnings().popTag();
    }
}

