/*
 * Decompiled with CFR 0.152.
 */
package org.xmcda.converters.v2_v3;

import java.util.List;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import org.xmcda.CategoriesMatrix;
import org.xmcda.Category;
import org.xmcda.Factory;
import org.xmcda.QualifiedValue;
import org.xmcda.QualifiedValues;
import org.xmcda.XMCDA;
import org.xmcda.converters.v2_v3.Converter;
import org.xmcda.converters.v2_v3.DescriptionConverter;
import org.xmcda.converters.v2_v3.QualifiedValueConverter;
import org.xmcda.converters.v2_v3.ScaleConverter;
import org.xmcda.utils.Coord;
import org.xmcda.v2.CategoriesMatrix;
import org.xmcda.v2.CategoriesSet;
import org.xmcda.v2.Value;
import org.xmcda.v2.Values;
import org.xmcda.value.NA;

public class CategoriesMatrixConverter
extends Converter {
    public static final String CATEGORIES_COMPARISONS = "categoriesComparisons";
    public static final String CATEGORIES_MATRIX = "categoriesMatrix";
    public static final String PAIRS = "pairs";
    public static final String PAIR = "pair";

    public CategoriesMatrixConverter() {
        super(CATEGORIES_MATRIX);
    }

    public void convertTo_v3(org.xmcda.v2.CategoriesMatrix value, XMCDA xmcda_v3) {
        this.getWarnings().pushTag(CATEGORIES_MATRIX, value.getId());
        CategoriesMatrix categoriesMatrix_v3 = Factory.categoriesMatrix();
        categoriesMatrix_v3.setId(value.getId());
        categoriesMatrix_v3.setMcdaConcept(value.getMcdaConcept());
        categoriesMatrix_v3.setName(value.getName());
        categoriesMatrix_v3.setDescription(new DescriptionConverter().convertTo_v3(value.getDescription()));
        if (value.getValuation() != null) {
            categoriesMatrix_v3.setValuation(new ScaleConverter().convertTo_v3(value.getValuation(), xmcda_v3));
        }
        for (CategoriesMatrix.Row row_v2 : value.getRow()) {
            String row_categoryID = row_v2.getCategoryID();
            String row_categorySetID = row_v2.getCategoriesSetID();
            CategoriesSet row_categoriesSet_v2 = row_v2.getCategoriesSet();
            if (row_categorySetID != null || row_categoriesSet_v2 != null) {
                this.getWarnings().throwUnimplemented();
            }
            Category row_category = (Category)xmcda_v3.categories.get(row_categoryID, true);
            for (CategoriesMatrix.Row.Column column_v2 : row_v2.getColumn()) {
                QualifiedValue<NA> value_v3;
                String column_categoryID = column_v2.getCategoryID();
                String column_categorySetID = column_v2.getCategoriesSetID();
                CategoriesSet column_categoriesSet_v2 = row_v2.getCategoriesSet();
                if (column_categorySetID != null || column_categoriesSet_v2 != null) {
                    this.getWarnings().throwUnimplemented();
                }
                Category column_category = (Category)xmcda_v3.categories.get(column_categoryID, true);
                if (column_v2.getValue() == null) {
                    value_v3 = Factory.qualifiedValue();
                    value_v3.setValue(NA.na);
                } else {
                    value_v3 = new QualifiedValueConverter().convertTo_v3(column_v2.getValue(), xmcda_v3);
                }
                Coord<Category, Category> coord_v3 = new Coord<Category, Category>(row_category, column_category);
                QualifiedValues values_v3 = Factory.qualifiedValues();
                values_v3.add(value_v3);
                categoriesMatrix_v3.put(coord_v3, values_v3);
            }
        }
        this.getWarnings().popTag();
        xmcda_v3.categoriesMatricesList.add(categoriesMatrix_v3);
    }

    public void convertTo_v2(List<CategoriesMatrix<?>> categoriesMatrices_v3, org.xmcda.v2.XMCDA xmcda_v2) {
        for (CategoriesMatrix<?> categoriesMatrix_v3 : categoriesMatrices_v3) {
            this.convertTo_v2(categoriesMatrix_v3, xmcda_v2);
        }
    }

    public void convertTo_v2(CategoriesMatrix categoriesMatrix_v3, org.xmcda.v2.XMCDA xmcda_v2) {
        this.getWarnings().pushTag(CATEGORIES_MATRIX, categoriesMatrix_v3.id());
        org.xmcda.v2.CategoriesMatrix categoriesMatrix_v2 = new org.xmcda.v2.CategoriesMatrix();
        List<JAXBElement<?>> alts = xmcda_v2.getProjectReferenceOrMethodMessagesOrMethodParameters();
        alts.add(new JAXBElement(new QName(CATEGORIES_MATRIX), org.xmcda.v2.CategoriesMatrix.class, (Object)categoriesMatrix_v2));
        categoriesMatrix_v2.setId(categoriesMatrix_v3.id());
        categoriesMatrix_v2.setName(categoriesMatrix_v3.name());
        categoriesMatrix_v2.setMcdaConcept(categoriesMatrix_v3.mcdaConcept());
        categoriesMatrix_v2.setValuation(new ScaleConverter().convertTo_v2(categoriesMatrix_v3.getValuation()));
        for (Object _coord : categoriesMatrix_v3.keySet()) {
            Coord coord = (Coord)_coord;
            CategoriesMatrix.Row row_v2 = new CategoriesMatrix.Row();
            categoriesMatrix_v2.getRow().add(row_v2);
            CategoriesMatrix.Row.Column col_v2 = new CategoriesMatrix.Row.Column();
            row_v2.getColumn().add(col_v2);
            row_v2.setCategoryID(((Category)coord.x).id());
            col_v2.setCategoryID(((Category)coord.y).id());
            Values values_v2 = new Values();
            QualifiedValues values_v3 = (QualifiedValues)categoriesMatrix_v3.get(_coord);
            if (values_v3 == null || values_v3.isEmpty()) continue;
            QualifiedValue value = (QualifiedValue)values_v3.get(0);
            Value value_v2 = new QualifiedValueConverter().convertTo_v2(value);
            col_v2.setValue(value_v2);
        }
        this.getWarnings().popTag();
    }
}

