/*
 * Decompiled with CFR 0.152.
 */
package org.xmcda.converters.v2_v3;

import java.util.List;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import org.xmcda.CategoriesMatrix;
import org.xmcda.CategoriesSet;
import org.xmcda.CategoriesSetsMatrix;
import org.xmcda.Category;
import org.xmcda.Factory;
import org.xmcda.QualifiedValue;
import org.xmcda.QualifiedValues;
import org.xmcda.XMCDA;
import org.xmcda.converters.v2_v3.CategoriesSetConverter;
import org.xmcda.converters.v2_v3.Converter;
import org.xmcda.converters.v2_v3.DescriptionConverter;
import org.xmcda.converters.v2_v3.QualifiedValueConverter;
import org.xmcda.converters.v2_v3.ScaleConverter;
import org.xmcda.utils.Coord;
import org.xmcda.v2.CategoriesComparisons;
import org.xmcda.v2.CategoryReference;
import org.xmcda.v2.Value;
import org.xmcda.v2.Values;
import org.xmcda.value.NA;

public class CategoriesComparisonsConverter
extends Converter {
    public static final String CATEGORIES_COMPARISONS = "categoriesComparisons";
    public static final String PAIRS = "pairs";
    public static final String PAIR = "pair";

    public CategoriesComparisonsConverter() {
        super(CATEGORIES_COMPARISONS);
    }

    public void convertTo_v3(CategoriesComparisons value, XMCDA xmcda_v3) {
        CategoriesComparisons.Pairs pairs = value.getPairs();
        if (pairs == null || pairs.getPair().size() == 0) {
            this.convertCategoriesComparisonsTo_v3(value, xmcda_v3);
            return;
        }
        CategoriesComparisons.Pairs.Pair pair = pairs.getPair().get(0);
        String initial_id = pair.getInitial().getCategoryID();
        if (initial_id != null) {
            this.convertCategoriesComparisonsTo_v3(value, xmcda_v3);
        } else {
            this.convertCategoriesSetsComparisonsTo_v3(value, xmcda_v3);
        }
    }

    public void convertCategoriesSetsComparisonsTo_v3(CategoriesComparisons value, XMCDA xmcda_v3) {
        CategoriesComparisons.Pairs pairs;
        this.getWarnings().pushTag(CATEGORIES_COMPARISONS, value.getId());
        CategoriesSetsMatrix categoriesSetsMatrix_v3 = Factory.categoriesSetsMatrix();
        categoriesSetsMatrix_v3.setId(value.getId());
        categoriesSetsMatrix_v3.setMcdaConcept(value.getMcdaConcept());
        categoriesSetsMatrix_v3.setName(value.getName());
        categoriesSetsMatrix_v3.setDescription(new DescriptionConverter().convertTo_v3(value.getDescription()));
        if (value.getValuation() != null) {
            categoriesSetsMatrix_v3.setValuation(new ScaleConverter().convertTo_v3(value.getValuation(), xmcda_v3));
        }
        if (value.getPairs().getDescription() != null) {
            this.getWarnings().elementIgnored("description", "Concept does not exist in XMCDA v3");
        }
        if ((pairs = value.getPairs()) == null || pairs.getPair().size() == 0) {
            this.getWarnings().elementUnimplemented("empty v2");
            return;
        }
        this.getWarnings().pushTag(PAIRS, value.getId());
        String comparisonType = value.getComparisonType();
        if (comparisonType != null && !"".equals(comparisonType)) {
            this.getWarnings().elementIgnored("comparisonType");
        }
        for (CategoriesComparisons.Pairs.Pair pair : pairs.getPair()) {
            CategoriesSet initial = null;
            String initial_id = pair.getInitial().getCategoryID();
            String initial_set_id = pair.getInitial().getCategoriesSetID();
            org.xmcda.v2.CategoriesSet initial_set = pair.getInitial().getCategoriesSet();
            if (initial_id != null) {
                throw new IllegalArgumentException("categoryID unexpected");
            }
            if (initial_set_id != null) {
                initial = (CategoriesSet)xmcda_v3.categoriesSets.get(initial_set_id, true);
            } else if (initial_set != null) {
                initial = new CategoriesSetConverter().convertTo_v3(initial_set, xmcda_v3);
                xmcda_v3.categoriesSets.add(initial);
            } else {
                throw new IllegalArgumentException("Invalid pair, no categoriesSetID nor categoriesSet in initial");
            }
            CategoriesSet terminal = null;
            String terminal_id = pair.getTerminal().getCategoryID();
            String terminal_set_id = pair.getTerminal().getCategoriesSetID();
            org.xmcda.v2.CategoriesSet terminal_set = pair.getTerminal().getCategoriesSet();
            if (terminal_id != null) {
                throw new IllegalArgumentException("categoryID unexpected");
            }
            if (terminal_set_id != null) {
                terminal = (CategoriesSet)xmcda_v3.categoriesSets.get(terminal_set_id, true);
            } else if (terminal_set != null) {
                terminal = new CategoriesSetConverter().convertTo_v3(terminal_set, xmcda_v3);
                xmcda_v3.categoriesSets.add(terminal);
            } else {
                throw new IllegalArgumentException("Invalid pair, no categoriesSetID nor categoriesSet in initial");
            }
            List<Object> pairValue_v2 = pair.getValueOrValues();
            QualifiedValues values_v3 = Factory.qualifiedValues();
            if (pairValue_v2 == null || pairValue_v2.size() == 0) {
                QualifiedValue<NA> tmpValue = Factory.qualifiedValue();
                tmpValue.setValue(NA.na);
                values_v3.add(tmpValue);
            } else {
                for (Object valueOrValues : pairValue_v2) {
                    if (valueOrValues instanceof Value) {
                        Value tmpValue_v2 = (Value)valueOrValues;
                        values_v3.add(new QualifiedValueConverter().convertTo_v3(tmpValue_v2, xmcda_v3));
                        continue;
                    }
                    Values tmpValues_v2 = (Values)valueOrValues;
                    for (Value tmpValue_v2 : tmpValues_v2.getValue()) {
                        values_v3.add(new QualifiedValueConverter().convertTo_v3(tmpValue_v2, xmcda_v3));
                    }
                }
            }
            categoriesSetsMatrix_v3.put(new Coord<CategoriesSet, CategoriesSet>(initial, terminal), values_v3);
        }
        this.getWarnings().popTag();
        this.getWarnings().popTag();
        xmcda_v3.categoriesSetsMatricesList.add(categoriesSetsMatrix_v3);
    }

    public void convertCategoriesComparisonsTo_v3(CategoriesComparisons value, XMCDA xmcda_v3) {
        CategoriesComparisons.Pairs pairs;
        this.getWarnings().pushTag(CATEGORIES_COMPARISONS, value.getId());
        CategoriesMatrix categoriesMatrix_v3 = Factory.categoriesMatrix();
        categoriesMatrix_v3.setId(value.getId());
        categoriesMatrix_v3.setMcdaConcept(value.getMcdaConcept());
        categoriesMatrix_v3.setName(value.getName());
        categoriesMatrix_v3.setDescription(new DescriptionConverter().convertTo_v3(value.getDescription()));
        if (value.getValuation() != null) {
            categoriesMatrix_v3.setValuation(new ScaleConverter().convertTo_v3(value.getValuation(), xmcda_v3));
        }
        if (value.getPairs().getDescription() != null) {
            this.getWarnings().elementIgnored("description", "Concept does not exist in XMCDA v3");
        }
        if ((pairs = value.getPairs()) == null || pairs.getPair().size() == 0) {
            this.getWarnings().elementUnimplemented("empty v2");
            return;
        }
        this.getWarnings().pushTag(PAIRS, value.getId());
        String comparisonType = value.getComparisonType();
        if (comparisonType != null && !"".equals(comparisonType)) {
            this.getWarnings().elementIgnored("comparisonType");
        }
        for (CategoriesComparisons.Pairs.Pair pair : pairs.getPair()) {
            Object initial = null;
            String initial_id = pair.getInitial().getCategoryID();
            String initial_set_id = pair.getInitial().getCategoriesSetID();
            org.xmcda.v2.CategoriesSet initial_set = pair.getInitial().getCategoriesSet();
            if (initial_id == null) {
                if (initial_set_id != null) {
                    throw new IllegalArgumentException("categoriesSetID unexpected");
                }
                if (initial_set != null) {
                    throw new IllegalArgumentException("categoriesSet unexpected");
                }
                throw new IllegalArgumentException("Invalid pair, no categoriesID in initial");
            }
            initial = xmcda_v3.categories.get(initial_id, true);
            Object terminal = null;
            String terminal_id = pair.getTerminal().getCategoryID();
            String terminal_set_id = pair.getTerminal().getCategoriesSetID();
            org.xmcda.v2.CategoriesSet terminal_set = pair.getTerminal().getCategoriesSet();
            if (terminal_id == null) {
                if (terminal_set_id != null) {
                    throw new IllegalArgumentException("categoriesSetID unexpected");
                }
                if (terminal_set != null) {
                    throw new IllegalArgumentException("categoriesSet unexpected");
                }
                throw new IllegalArgumentException("Invalid pair, no categoriesID in terminal");
            }
            terminal = xmcda_v3.categories.get(terminal_id, true);
            List<Object> pairValue_v2 = pair.getValueOrValues();
            QualifiedValues values_v3 = Factory.qualifiedValues();
            if (pairValue_v2 == null || pairValue_v2.size() == 0) {
                QualifiedValue<NA> tmpValue = Factory.qualifiedValue();
                tmpValue.setValue(NA.na);
                values_v3.add(tmpValue);
            } else {
                for (Object valueOrValues : pairValue_v2) {
                    if (valueOrValues instanceof Value) {
                        Value tmpValue_v2 = (Value)valueOrValues;
                        values_v3.add(new QualifiedValueConverter().convertTo_v3(tmpValue_v2, xmcda_v3));
                        continue;
                    }
                    Values tmpValues_v2 = (Values)valueOrValues;
                    for (Value tmpValue_v2 : tmpValues_v2.getValue()) {
                        values_v3.add(new QualifiedValueConverter().convertTo_v3(tmpValue_v2, xmcda_v3));
                    }
                }
            }
            categoriesMatrix_v3.put(new Coord<Object, Object>(initial, terminal), values_v3);
        }
        this.getWarnings().popTag();
        this.getWarnings().popTag();
        xmcda_v3.categoriesMatricesList.add(categoriesMatrix_v3);
    }

    public void convertCategoriesMatricesTo_v2(List<CategoriesMatrix<?>> categoriesMatrices_v3, org.xmcda.v2.XMCDA xmcda_v2) {
        for (CategoriesMatrix<?> categoriesMatrix_v3 : categoriesMatrices_v3) {
            this.convertCategoriesMatrixTo_v2(categoriesMatrix_v3, xmcda_v2);
        }
    }

    public void convertCategoriesMatrixTo_v2(CategoriesMatrix categoriesMatrix_v3, org.xmcda.v2.XMCDA xmcda_v2) {
        this.getWarnings().pushTag("categoriesMatrix");
        CategoriesComparisons categoriesComparisons_v2 = new CategoriesComparisons();
        List<JAXBElement<?>> ccs = xmcda_v2.getProjectReferenceOrMethodMessagesOrMethodParameters();
        ccs.add(new JAXBElement(new QName(CATEGORIES_COMPARISONS), CategoriesComparisons.class, (Object)categoriesComparisons_v2));
        categoriesComparisons_v2.setId(categoriesMatrix_v3.id());
        categoriesComparisons_v2.setName(categoriesMatrix_v3.name());
        categoriesComparisons_v2.setMcdaConcept(categoriesMatrix_v3.mcdaConcept());
        categoriesComparisons_v2.setDescription(new DescriptionConverter().convertTo_v2(categoriesMatrix_v3.getDescription()));
        categoriesComparisons_v2.setValuation(new ScaleConverter().convertTo_v2(categoriesMatrix_v3.getValuation()));
        CategoriesComparisons.Pairs pairs_v2 = new CategoriesComparisons.Pairs();
        categoriesComparisons_v2.setPairs(pairs_v2);
        for (Object _coord : categoriesMatrix_v3.keySet()) {
            Coord coord = (Coord)_coord;
            CategoriesComparisons.Pairs.Pair pair_v2 = new CategoriesComparisons.Pairs.Pair();
            CategoryReference categoryRef_initial = new CategoryReference();
            categoryRef_initial.setCategoryID(((Category)coord.x).id());
            CategoryReference categoryRef_terminal = new CategoryReference();
            categoryRef_terminal.setCategoryID(((Category)coord.y).id());
            pair_v2.setInitial(categoryRef_initial);
            pair_v2.setTerminal(categoryRef_terminal);
            Values values_v2 = new Values();
            QualifiedValues values_v3 = (QualifiedValues)categoriesMatrix_v3.get(_coord);
            if (values_v3 != null) {
                for (Object _value : values_v3) {
                    QualifiedValue value = (QualifiedValue)_value;
                    Value value_v2 = new QualifiedValueConverter().convertTo_v2(value);
                    values_v2.getValue().add(value_v2);
                }
            }
            pair_v2.getValueOrValues().add(values_v2);
            pairs_v2.getPair().add(pair_v2);
        }
        this.getWarnings().popTag();
    }

    public void convertCategoriesSetsMatricesTo_v2(List<CategoriesSetsMatrix<?, ?>> categoriesSetsMatrices_v3, org.xmcda.v2.XMCDA xmcda_v2) {
        for (CategoriesSetsMatrix<?, ?> categoriesSetsMatrix_v3 : categoriesSetsMatrices_v3) {
            this.convertCategoriesSetsMatrixTo_v2(categoriesSetsMatrix_v3, xmcda_v2);
        }
    }

    public void convertCategoriesSetsMatrixTo_v2(CategoriesSetsMatrix categoriesSetsMatrix_v3, org.xmcda.v2.XMCDA xmcda_v2) {
        this.getWarnings().pushTag("categoriesMatrix");
        CategoriesComparisons categoriesComparisons_v2 = new CategoriesComparisons();
        List<JAXBElement<?>> ccs = xmcda_v2.getProjectReferenceOrMethodMessagesOrMethodParameters();
        ccs.add(new JAXBElement(new QName(CATEGORIES_COMPARISONS), CategoriesComparisons.class, (Object)categoriesComparisons_v2));
        categoriesComparisons_v2.setId(categoriesSetsMatrix_v3.id());
        categoriesComparisons_v2.setName(categoriesSetsMatrix_v3.name());
        categoriesComparisons_v2.setMcdaConcept(categoriesSetsMatrix_v3.mcdaConcept());
        categoriesComparisons_v2.setDescription(new DescriptionConverter().convertTo_v2(categoriesSetsMatrix_v3.getDescription()));
        categoriesComparisons_v2.setValuation(new ScaleConverter().convertTo_v2(categoriesSetsMatrix_v3.getValuation()));
        CategoriesComparisons.Pairs pairs_v2 = new CategoriesComparisons.Pairs();
        categoriesComparisons_v2.setPairs(pairs_v2);
        for (Object _coord : categoriesSetsMatrix_v3.keySet()) {
            Coord coord = (Coord)_coord;
            CategoriesComparisons.Pairs.Pair pair_v2 = new CategoriesComparisons.Pairs.Pair();
            CategoryReference categoryRef_initial = new CategoryReference();
            categoryRef_initial.setCategoriesSetID(((CategoriesSet)coord.x).id());
            CategoryReference categoryRef_terminal = new CategoryReference();
            categoryRef_terminal.setCategoriesSetID(((CategoriesSet)coord.y).id());
            pair_v2.setInitial(categoryRef_initial);
            pair_v2.setTerminal(categoryRef_terminal);
            Values values_v2 = new Values();
            QualifiedValues values_v3 = (QualifiedValues)categoriesSetsMatrix_v3.get(_coord);
            if (values_v3 != null) {
                for (Object _value : values_v3) {
                    QualifiedValue value = (QualifiedValue)_value;
                    Value value_v2 = new QualifiedValueConverter().convertTo_v2(value);
                    values_v2.getValue().add(value_v2);
                }
            }
            pair_v2.getValueOrValues().add(values_v2);
            pairs_v2.getPair().add(pair_v2);
        }
        this.getWarnings().popTag();
    }
}

