/*
 * Decompiled with CFR 0.152.
 */
package org.xmcda.converters.v2_v3;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import org.xmcda.Alternative;
import org.xmcda.AlternativesMatrix;
import org.xmcda.AlternativesSet;
import org.xmcda.AlternativesSetsMatrix;
import org.xmcda.Factory;
import org.xmcda.QualifiedValue;
import org.xmcda.QualifiedValues;
import org.xmcda.XMCDA;
import org.xmcda.converters.v2_v3.AlternativesSetConverter;
import org.xmcda.converters.v2_v3.Converter;
import org.xmcda.converters.v2_v3.DescriptionConverter;
import org.xmcda.converters.v2_v3.QualifiedValueConverter;
import org.xmcda.converters.v2_v3.ScaleConverter;
import org.xmcda.utils.Coord;
import org.xmcda.v2.AlternativeReference;
import org.xmcda.v2.AlternativesComparisons;
import org.xmcda.v2.Value;
import org.xmcda.v2.Values;
import org.xmcda.value.NA;

public class AlternativesComparisonsConverter
extends Converter {
    public static final String ALTERNATIVES_COMPARISONS = "alternativesComparisons";
    public static final String PAIRS = "pairs";
    public static final String PAIR = "pair";

    public AlternativesComparisonsConverter() {
        super(ALTERNATIVES_COMPARISONS);
    }

    public void convertTo_v3(AlternativesComparisons value, XMCDA xmcda_v3) {
        AlternativesComparisons.Pairs pairs = value.getPairs();
        if (pairs == null || pairs.getPair().size() == 0) {
            this.convertAlternativesComparisonsTo_v3(value, xmcda_v3);
            return;
        }
        AlternativesComparisons.Pairs.Pair pair = pairs.getPair().get(0);
        String initial_id = pair.getInitial().getAlternativeID();
        if (initial_id != null) {
            this.convertAlternativesComparisonsTo_v3(value, xmcda_v3);
        } else {
            this.convertAlternativesSetsComparisonsTo_v3(value, xmcda_v3);
        }
    }

    public void convertAlternativesSetsComparisonsTo_v3(AlternativesComparisons value, XMCDA xmcda_v3) {
        AlternativesComparisons.Pairs pairs;
        this.getWarnings().pushTag(ALTERNATIVES_COMPARISONS, value.getId());
        AlternativesSetsMatrix alternativesSetsMatrix_v3 = Factory.alternativesSetsMatrix();
        alternativesSetsMatrix_v3.setId(value.getId());
        alternativesSetsMatrix_v3.setMcdaConcept(value.getMcdaConcept());
        alternativesSetsMatrix_v3.setName(value.getName());
        alternativesSetsMatrix_v3.setDescription(new DescriptionConverter().convertTo_v3(value.getDescription()));
        if (value.getValuation() != null) {
            alternativesSetsMatrix_v3.setValuation(new ScaleConverter().convertTo_v3(value.getValuation(), xmcda_v3));
        }
        if (value.getPairs().getDescription() != null) {
            this.getWarnings().elementIgnored("description", "Concept does not exist in XMCDA v3");
        }
        if ((pairs = value.getPairs()) == null || pairs.getPair().size() == 0) {
            this.getWarnings().elementUnimplemented("empty v2");
            return;
        }
        this.getWarnings().pushTag(PAIRS, value.getId());
        String comparisonType = value.getComparisonType();
        if (comparisonType != null && !"".equals(comparisonType)) {
            this.getWarnings().elementIgnored("comparisonType");
        }
        for (AlternativesComparisons.Pairs.Pair pair : pairs.getPair()) {
            AlternativesSet initial = null;
            String initial_id = pair.getInitial().getAlternativeID();
            String initial_set_id = pair.getInitial().getAlternativesSetID();
            org.xmcda.v2.AlternativesSet initial_set = pair.getInitial().getAlternativesSet();
            if (initial_id != null) {
                throw new IllegalArgumentException("alternativeID unexpected");
            }
            if (initial_set_id != null) {
                initial = (AlternativesSet)xmcda_v3.alternativesSets.get(initial_set_id, true);
            } else if (initial_set != null) {
                initial = new AlternativesSetConverter().convertTo_v3(initial_set, xmcda_v3);
                xmcda_v3.alternativesSets.add(initial);
            } else {
                throw new IllegalArgumentException("Invalid pair, no alternativesSetID nor alternativesSet in initial");
            }
            AlternativesSet terminal = null;
            String terminal_id = pair.getTerminal().getAlternativeID();
            String terminal_set_id = pair.getTerminal().getAlternativesSetID();
            org.xmcda.v2.AlternativesSet terminal_set = pair.getTerminal().getAlternativesSet();
            if (terminal_id != null) {
                throw new IllegalArgumentException("alternativeID unexpected");
            }
            if (terminal_set_id != null) {
                terminal = (AlternativesSet)xmcda_v3.alternativesSets.get(terminal_set_id, true);
            } else if (terminal_set != null) {
                terminal = new AlternativesSetConverter().convertTo_v3(terminal_set, xmcda_v3);
                xmcda_v3.alternativesSets.add(terminal);
            } else {
                throw new IllegalArgumentException("Invalid pair, no alternativesSetID nor alternativesSet in initial");
            }
            ArrayList<Object> pairValue_v2 = new ArrayList<Object>();
            for (Value value2 : pair.getValue()) {
                pairValue_v2.add(value2);
            }
            for (Object object : pair.getValues()) {
                pairValue_v2.add(object);
            }
            QualifiedValues values_v3 = Factory.qualifiedValues();
            if (pairValue_v2 == null || pairValue_v2.size() == 0) {
                QualifiedValue<NA> qualifiedValue = Factory.qualifiedValue();
                qualifiedValue.setValue(NA.na);
                values_v3.add(qualifiedValue);
            } else {
                for (Object e : pairValue_v2) {
                    if (e instanceof Value) {
                        Value tmpValue_v2 = (Value)e;
                        values_v3.add(new QualifiedValueConverter().convertTo_v3(tmpValue_v2, xmcda_v3));
                        continue;
                    }
                    Values tmpValues_v2 = (Values)e;
                    for (Value tmpValue_v2 : tmpValues_v2.getValue()) {
                        values_v3.add(new QualifiedValueConverter().convertTo_v3(tmpValue_v2, xmcda_v3));
                    }
                }
            }
            alternativesSetsMatrix_v3.put(new Coord<AlternativesSet, AlternativesSet>(initial, terminal), values_v3);
        }
        this.getWarnings().popTag();
        this.getWarnings().popTag();
        xmcda_v3.alternativesSetsMatricesList.add(alternativesSetsMatrix_v3);
    }

    public void convertAlternativesComparisonsTo_v3(AlternativesComparisons value, XMCDA xmcda_v3) {
        AlternativesComparisons.Pairs pairs;
        this.getWarnings().pushTag(ALTERNATIVES_COMPARISONS, value.getId());
        AlternativesMatrix alternativesMatrix_v3 = Factory.alternativesMatrix();
        alternativesMatrix_v3.setId(value.getId());
        alternativesMatrix_v3.setMcdaConcept(value.getMcdaConcept());
        alternativesMatrix_v3.setName(value.getName());
        alternativesMatrix_v3.setDescription(new DescriptionConverter().convertTo_v3(value.getDescription()));
        if (value.getValuation() != null) {
            alternativesMatrix_v3.setValuation(new ScaleConverter().convertTo_v3(value.getValuation(), xmcda_v3));
        }
        if (value.getPairs().getDescription() != null) {
            this.getWarnings().elementIgnored("description", "Concept does not exist in XMCDA v3");
        }
        if ((pairs = value.getPairs()) == null || pairs.getPair().size() == 0) {
            this.getWarnings().elementUnimplemented("empty v2");
            return;
        }
        this.getWarnings().pushTag(PAIRS, value.getId());
        String comparisonType = value.getComparisonType();
        if (comparisonType != null && !"".equals(comparisonType)) {
            this.getWarnings().elementIgnored("comparisonType");
        }
        for (AlternativesComparisons.Pairs.Pair pair : pairs.getPair()) {
            Object initial = null;
            String initial_id = pair.getInitial().getAlternativeID();
            String initial_set_id = pair.getInitial().getAlternativesSetID();
            org.xmcda.v2.AlternativesSet initial_set = pair.getInitial().getAlternativesSet();
            if (initial_id == null) {
                if (initial_set_id != null) {
                    throw new IllegalArgumentException("alternativesSetID unexpected");
                }
                if (initial_set != null) {
                    throw new IllegalArgumentException("alternativesSet unexpected");
                }
                throw new IllegalArgumentException("Invalid pair, no alternativesID in initial");
            }
            initial = xmcda_v3.alternatives.get(initial_id, true);
            Object terminal = null;
            String terminal_id = pair.getTerminal().getAlternativeID();
            String terminal_set_id = pair.getTerminal().getAlternativesSetID();
            org.xmcda.v2.AlternativesSet terminal_set = pair.getTerminal().getAlternativesSet();
            if (terminal_id == null) {
                if (terminal_set_id != null) {
                    throw new IllegalArgumentException("alternativesSetID unexpected");
                }
                if (terminal_set != null) {
                    throw new IllegalArgumentException("alternativesSet unexpected");
                }
                throw new IllegalArgumentException("Invalid pair, no alternativesID in terminal");
            }
            terminal = xmcda_v3.alternatives.get(terminal_id, true);
            ArrayList<Object> pairValue_v2 = new ArrayList<Object>();
            for (Value value2 : pair.getValue()) {
                pairValue_v2.add(value2);
            }
            for (Object object : pair.getValues()) {
                pairValue_v2.add(object);
            }
            QualifiedValues values_v3 = Factory.qualifiedValues();
            if (pairValue_v2 == null || pairValue_v2.size() == 0) {
                QualifiedValue<NA> qualifiedValue = Factory.qualifiedValue();
                qualifiedValue.setValue(NA.na);
                values_v3.add(qualifiedValue);
            } else {
                for (Object e : pairValue_v2) {
                    if (e instanceof Value) {
                        Value tmpValue_v2 = (Value)e;
                        values_v3.add(new QualifiedValueConverter().convertTo_v3(tmpValue_v2, xmcda_v3));
                        continue;
                    }
                    Values tmpValues_v2 = (Values)e;
                    for (Value tmpValue_v2 : tmpValues_v2.getValue()) {
                        values_v3.add(new QualifiedValueConverter().convertTo_v3(tmpValue_v2, xmcda_v3));
                    }
                }
            }
            alternativesMatrix_v3.put(new Coord<Object, Object>(initial, terminal), values_v3);
        }
        this.getWarnings().popTag();
        this.getWarnings().popTag();
        xmcda_v3.alternativesMatricesList.add(alternativesMatrix_v3);
    }

    public void convertAlternativesMatricesTo_v2(List<AlternativesMatrix<?>> alternativesMatrices_v3, org.xmcda.v2.XMCDA xmcda_v2) {
        for (AlternativesMatrix<?> alternativesMatrix_v3 : alternativesMatrices_v3) {
            this.convertAlternativesMatrixTo_v2(alternativesMatrix_v3, xmcda_v2);
        }
    }

    public void convertAlternativesMatrixTo_v2(AlternativesMatrix alternativesMatrix_v3, org.xmcda.v2.XMCDA xmcda_v2) {
        this.getWarnings().pushTag("alternativesMatrix");
        AlternativesComparisons alternativesComparisons_v2 = new AlternativesComparisons();
        List<JAXBElement<?>> ccs = xmcda_v2.getProjectReferenceOrMethodMessagesOrMethodParameters();
        ccs.add(new JAXBElement(new QName(ALTERNATIVES_COMPARISONS), AlternativesComparisons.class, (Object)alternativesComparisons_v2));
        alternativesComparisons_v2.setId(alternativesMatrix_v3.id());
        alternativesComparisons_v2.setName(alternativesMatrix_v3.name());
        alternativesComparisons_v2.setMcdaConcept(alternativesMatrix_v3.mcdaConcept());
        alternativesComparisons_v2.setDescription(new DescriptionConverter().convertTo_v2(alternativesMatrix_v3.getDescription()));
        alternativesComparisons_v2.setValuation(new ScaleConverter().convertTo_v2(alternativesMatrix_v3.getValuation()));
        AlternativesComparisons.Pairs pairs_v2 = new AlternativesComparisons.Pairs();
        alternativesComparisons_v2.setPairs(pairs_v2);
        for (Object _coord : alternativesMatrix_v3.keySet()) {
            Coord coord = (Coord)_coord;
            AlternativesComparisons.Pairs.Pair pair_v2 = new AlternativesComparisons.Pairs.Pair();
            AlternativeReference alternativeRef_initial = new AlternativeReference();
            alternativeRef_initial.setAlternativeID(((Alternative)coord.x).id());
            AlternativeReference alternativeRef_terminal = new AlternativeReference();
            alternativeRef_terminal.setAlternativeID(((Alternative)coord.y).id());
            pair_v2.setInitial(alternativeRef_initial);
            pair_v2.setTerminal(alternativeRef_terminal);
            Values values_v2 = new Values();
            QualifiedValues values_v3 = (QualifiedValues)alternativesMatrix_v3.get(_coord);
            if (values_v3 != null) {
                for (Object _value : values_v3) {
                    QualifiedValue value = (QualifiedValue)_value;
                    Value value_v2 = new QualifiedValueConverter().convertTo_v2(value);
                    values_v2.getValue().add(value_v2);
                }
            }
            pair_v2.getValues().add(values_v2);
            pairs_v2.getPair().add(pair_v2);
        }
        this.getWarnings().popTag();
    }

    public void convertAlternativesSetsMatricesTo_v2(List<AlternativesSetsMatrix<?, ?>> alternativesSetsMatrices_v3, org.xmcda.v2.XMCDA xmcda_v2) {
        for (AlternativesSetsMatrix<?, ?> alternativesSetsMatrix_v3 : alternativesSetsMatrices_v3) {
            this.convertAlternativesSetsMatrixTo_v2(alternativesSetsMatrix_v3, xmcda_v2);
        }
    }

    public void convertAlternativesSetsMatrixTo_v2(AlternativesSetsMatrix alternativesSetsMatrix_v3, org.xmcda.v2.XMCDA xmcda_v2) {
        this.getWarnings().pushTag("alternativesMatrix");
        AlternativesComparisons alternativesComparisons_v2 = new AlternativesComparisons();
        List<JAXBElement<?>> ccs = xmcda_v2.getProjectReferenceOrMethodMessagesOrMethodParameters();
        ccs.add(new JAXBElement(new QName(ALTERNATIVES_COMPARISONS), AlternativesComparisons.class, (Object)alternativesComparisons_v2));
        alternativesComparisons_v2.setId(alternativesSetsMatrix_v3.id());
        alternativesComparisons_v2.setName(alternativesSetsMatrix_v3.name());
        alternativesComparisons_v2.setMcdaConcept(alternativesSetsMatrix_v3.mcdaConcept());
        alternativesComparisons_v2.setDescription(new DescriptionConverter().convertTo_v2(alternativesSetsMatrix_v3.getDescription()));
        alternativesComparisons_v2.setValuation(new ScaleConverter().convertTo_v2(alternativesSetsMatrix_v3.getValuation()));
        AlternativesComparisons.Pairs pairs_v2 = new AlternativesComparisons.Pairs();
        alternativesComparisons_v2.setPairs(pairs_v2);
        for (Object _coord : alternativesSetsMatrix_v3.keySet()) {
            Coord coord = (Coord)_coord;
            AlternativesComparisons.Pairs.Pair pair_v2 = new AlternativesComparisons.Pairs.Pair();
            AlternativeReference alternativeRef_initial = new AlternativeReference();
            alternativeRef_initial.setAlternativesSetID(((AlternativesSet)coord.x).id());
            AlternativeReference alternativeRef_terminal = new AlternativeReference();
            alternativeRef_terminal.setAlternativesSetID(((AlternativesSet)coord.y).id());
            pair_v2.setInitial(alternativeRef_initial);
            pair_v2.setTerminal(alternativeRef_terminal);
            Values values_v2 = new Values();
            QualifiedValues values_v3 = (QualifiedValues)alternativesSetsMatrix_v3.get(_coord);
            if (values_v3 != null) {
                for (Object _value : values_v3) {
                    QualifiedValue value = (QualifiedValue)_value;
                    Value value_v2 = new QualifiedValueConverter().convertTo_v2(value);
                    values_v2.getValue().add(value_v2);
                }
            }
            pair_v2.getValues().add(values_v2);
            pairs_v2.getPair().add(pair_v2);
        }
        this.getWarnings().popTag();
    }
}

