/*
 * Decompiled with CFR 0.152.
 */
package org.xmcda;

import java.io.Serializable;
import org.xmcda.CommonAttributes;
import org.xmcda.QualifiedValue;

public class Threshold<T>
implements CommonAttributes,
Serializable {
    private static final long serialVersionUID = 1L;
    private QualifiedValue<T> constant;
    private Type type;
    private QualifiedValue<T> slope;
    private QualifiedValue<T> intercept;
    private String id;
    private String name;
    private String mcdaConcept;

    public Threshold(QualifiedValue<T> constant) {
        this.setConstant(constant);
    }

    public Threshold(QualifiedValue<T> slope, QualifiedValue<T> intercept) {
        this.setAffine(slope, intercept);
    }

    public Threshold(Type type, QualifiedValue<T> slope, QualifiedValue<T> intercept) {
        this.setAffine(type, slope, intercept);
    }

    protected void reset() {
        this.constant = null;
        this.type = null;
        this.slope = null;
        this.intercept = null;
    }

    public boolean isConstant() {
        return this.constant != null;
    }

    public boolean isAffine() {
        return !this.isConstant();
    }

    public QualifiedValue<T> getConstant() {
        return this.constant;
    }

    public void setConstant(QualifiedValue<T> constant) {
        if (constant == null) {
            throw new NullPointerException("threshold's constant cannot be null");
        }
        this.reset();
        this.constant = constant;
    }

    public Type getType() {
        return this.type;
    }

    public QualifiedValue<T> getSlope() {
        return this.slope;
    }

    public QualifiedValue<T> getIntercept() {
        return this.intercept;
    }

    public void setAffine(QualifiedValue<T> slope, QualifiedValue<T> intercept) {
        if (slope == null) {
            throw new NullPointerException("threshold's slope cannot be null");
        }
        if (intercept == null) {
            throw new NullPointerException("threshold's intercept cannot be null");
        }
        this.reset();
        this.type = Type.DIRECT;
        this.slope = slope;
        this.intercept = intercept;
    }

    public void setAffine(Type type, QualifiedValue<T> slope, QualifiedValue<T> intercept) {
        this.setAffine(slope, intercept);
        this.setType(type);
    }

    public void setType(Type type) {
        if (!this.isAffine()) {
            throw new IllegalStateException("setType() cannot be called on a constant threshold");
        }
        if (type == null) {
            throw new NullPointerException("Threshold's type cannot be null");
        }
        this.type = type;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String mcdaConcept() {
        return this.mcdaConcept;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void setMcdaConcept(String mcdaConcept) {
        this.mcdaConcept = mcdaConcept;
    }

    public static enum Type {
        DIRECT,
        INVERSE;

    }
}

