/*
 * Decompiled with CFR 0.152.
 */
package org.xmcda;

import java.io.Serializable;
import org.xmcda.CommonAttributes;
import org.xmcda.Description;
import org.xmcda.HasDescription;
import org.xmcda.utils.ValueConverters;
import org.xmcda.value.FuzzyNumber;
import org.xmcda.value.Interval;
import org.xmcda.value.NA;
import org.xmcda.value.Rational;
import org.xmcda.value.ValuedLabel;

public class QualifiedValue<T>
implements CommonAttributes,
HasDescription,
Serializable {
    private static final long serialVersionUID = 1L;
    private T value;
    private String id;
    private String name;
    private String mcdaConcept;
    private Description description;

    public QualifiedValue() {
    }

    public QualifiedValue(T value) {
        this.value = value;
    }

    public T getValue() {
        return this.value;
    }

    public void setValue(T value) {
        this.value = value;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String mcdaConcept() {
        return this.mcdaConcept;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void setMcdaConcept(String mcdaConcept) {
        this.mcdaConcept = mcdaConcept;
    }

    @Override
    public void setDescription(Description description) {
        this.description = description;
    }

    @Override
    public Description getDescription() {
        return this.description;
    }

    public <DESTINATION> QualifiedValue<DESTINATION> convertTo(Class<DESTINATION> clazz) throws ValueConverters.ConversionException {
        QualifiedValue u = this;
        u.value = ValueConverters.convert(this.value, clazz);
        return u;
    }

    public QualifiedValue<Double> convertToDouble() throws ValueConverters.ConversionException {
        return this.convertTo(Double.class);
    }

    public boolean isNumeric() {
        if (this.value instanceof Integer) {
            return true;
        }
        if (this.value instanceof Float) {
            return true;
        }
        if (this.value instanceof Double) {
            return true;
        }
        if (this.value instanceof Rational) {
            return true;
        }
        if (this.value instanceof String) {
            try {
                Double.parseDouble((String)this.value);
            }
            catch (ClassCastException e) {
                return false;
            }
            catch (NumberFormatException e) {
                return false;
            }
            return true;
        }
        return false;
    }

    public String getXMCDATag() throws IllegalStateException, NullPointerException {
        return this.getXMCDAType().getTag();
    }

    public XMCDATypes getXMCDAType() throws IllegalStateException, NullPointerException {
        return XMCDATypes.getXMCDAType(this.value);
    }

    public static enum XMCDATypes {
        INTEGER("integer"),
        REAL("real"),
        LABEL("label"),
        BOOLEAN("boolean"),
        NA("NA"),
        RATIONAL("rational"),
        INTERVAL("interval"),
        FUZZY_NUMBER("fuzzyNumber"),
        VALUED_LABEL("valuedLabel");

        private String tag;

        private XMCDATypes(String tag) {
            if (tag == null || "".equals(tag)) {
                throw new IllegalArgumentException("XMCDA tag cannot be null");
            }
            this.tag = tag;
        }

        public String getTag() {
            return this.tag;
        }

        public static XMCDATypes getXMCDAType(Object value) throws IllegalStateException, NullPointerException {
            if (value == null) {
                throw new NullPointerException("value cannot be null");
            }
            if (value instanceof Integer) {
                return INTEGER;
            }
            if (value instanceof Double || value instanceof Float) {
                return REAL;
            }
            if (value instanceof String) {
                return LABEL;
            }
            if (value instanceof Boolean) {
                return BOOLEAN;
            }
            if (value instanceof NA) {
                return NA;
            }
            if (value instanceof Rational) {
                return RATIONAL;
            }
            if (value instanceof Interval) {
                return INTERVAL;
            }
            if (value instanceof FuzzyNumber) {
                return FUZZY_NUMBER;
            }
            if (value instanceof ValuedLabel) {
                return VALUED_LABEL;
            }
            throw new IllegalStateException("Invalid class " + value.getClass().getCanonicalName());
        }
    }
}

