/*
 * Decompiled with CFR 0.152.
 */
package org.xmcda;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Set;
import org.xmcda.Alternative;
import org.xmcda.CommonAttributes;
import org.xmcda.Description;
import org.xmcda.Factory;
import org.xmcda.HasDescription;
import org.xmcda.LabelledQValues;
import org.xmcda.QualifiedValue;
import org.xmcda.QualifiedValues;
import org.xmcda.XMCDARootElement;
import org.xmcda.utils.ValueConverters;

public class AlternativesValues<VALUE_TYPE>
extends LinkedHashMap<Alternative, LabelledQValues<VALUE_TYPE>>
implements HasDescription,
CommonAttributes,
XMCDARootElement {
    private static final long serialVersionUID = 1L;
    public static final String TAG = "alternativesValues";
    private String id;
    private String name;
    private String mcdaConcept;
    private Description description;

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String mcdaConcept() {
        return this.mcdaConcept;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void setMcdaConcept(String mcdaConcept) {
        this.mcdaConcept = mcdaConcept;
    }

    @Override
    public void setDescription(Description description) {
        this.description = description;
    }

    @Override
    public Description getDescription() {
        return this.description;
    }

    @Override
    public LabelledQValues<VALUE_TYPE> put(Alternative alternative, QualifiedValue<VALUE_TYPE> qvalue) {
        return this.put(alternative, new LabelledQValues<VALUE_TYPE>(qvalue));
    }

    @Override
    public LabelledQValues<VALUE_TYPE> put(Alternative alternative, VALUE_TYPE value) {
        if (value instanceof QualifiedValue) {
            return this.put(alternative, new LabelledQValues((QualifiedValue)value));
        }
        if (value instanceof LabelledQValues) {
            return super.put(alternative, (LabelledQValues)value);
        }
        return this.put(alternative, new LabelledQValues<VALUE_TYPE>(new QualifiedValue<VALUE_TYPE>(value)));
    }

    public LabelledQValues<VALUE_TYPE> setDefault(Alternative alternative, VALUE_TYPE defaultValue) {
        LabelledQValues values = (LabelledQValues)this.get(alternative);
        if (values == null) {
            values = Factory.labelledQValues();
            values.add(new QualifiedValue<VALUE_TYPE>(defaultValue));
            this.put(alternative, values);
        }
        return (LabelledQValues)this.get(alternative);
    }

    public boolean isNumeric() {
        for (LabelledQValues values : this.values()) {
            if (values.isNumeric()) continue;
            return false;
        }
        return true;
    }

    public Set<Alternative> getAlternatives() {
        LinkedHashSet<Alternative> alternatives = new LinkedHashSet<Alternative>();
        for (Alternative c : this.keySet()) {
            alternatives.add(c);
        }
        return alternatives;
    }

    public AlternativesValues<Double> asDouble() throws ValueConverters.ConversionException {
        return this.convertTo(Double.class);
    }

    public <U> AlternativesValues<U> convertTo(Class<U> clazz) throws ValueConverters.ConversionException {
        for (QualifiedValues values : this.values()) {
            values.convertTo(clazz);
        }
        return this;
    }
}

