/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.system;

import java.io.File;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.context.embedded.EmbeddedServletContainerInitializedEvent;
import org.springframework.boot.context.embedded.EmbeddedWebApplicationContext;
import org.springframework.boot.system.SystemProperties;
import org.springframework.context.ApplicationListener;
import org.springframework.util.Assert;
import org.springframework.util.FileCopyUtils;
import org.springframework.util.StringUtils;

public class EmbeddedServerPortFileWriter
implements ApplicationListener<EmbeddedServletContainerInitializedEvent> {
    private static final String DEFAULT_FILE_NAME = "application.port";
    private static final String[] PROPERTY_VARIABLES = new String[]{"PORTFILE", "portfile"};
    private static final Log logger = LogFactory.getLog(EmbeddedServerPortFileWriter.class);
    private final File file;

    public EmbeddedServerPortFileWriter() {
        this(new File(DEFAULT_FILE_NAME));
    }

    public EmbeddedServerPortFileWriter(String filename) {
        this(new File(filename));
    }

    public EmbeddedServerPortFileWriter(File file) {
        Assert.notNull(file, "File must not be null");
        String override = SystemProperties.get(PROPERTY_VARIABLES);
        this.file = override != null ? new File(override) : file;
    }

    @Override
    public void onApplicationEvent(EmbeddedServletContainerInitializedEvent event) {
        File portFile = this.getPortFile(event.getApplicationContext());
        try {
            String port = String.valueOf(event.getEmbeddedServletContainer().getPort());
            this.createParentFolder(portFile);
            FileCopyUtils.copy(port.getBytes(), portFile);
            portFile.deleteOnExit();
        }
        catch (Exception ex) {
            logger.warn(String.format("Cannot create port file %s", this.file));
        }
    }

    protected File getPortFile(EmbeddedWebApplicationContext applicationContext) {
        String contextName = applicationContext.getNamespace();
        if (StringUtils.isEmpty(contextName)) {
            return this.file;
        }
        String name = this.file.getName();
        String extension = StringUtils.getFilenameExtension(this.file.getName());
        name = this.isUpperCase(name = name.substring(0, name.length() - extension.length() - 1)) ? name + "-" + contextName.toUpperCase() : name + "-" + contextName.toLowerCase();
        if (StringUtils.hasLength(extension)) {
            name = name + "." + extension;
        }
        return new File(this.file.getParentFile(), name);
    }

    private boolean isUpperCase(String name) {
        for (int i = 0; i < name.length(); ++i) {
            if (!Character.isLetter(name.charAt(i)) || Character.isUpperCase(name.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private void createParentFolder(File file) {
        File parent = file.getParentFile();
        if (parent != null) {
            parent.mkdirs();
        }
    }
}

