/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.jta.narayana;

import com.arjuna.ats.arjuna.recovery.RecoveryManager;
import com.arjuna.ats.arjuna.recovery.RecoveryModule;
import com.arjuna.ats.internal.jta.recovery.arjunacore.XARecoveryModule;
import com.arjuna.ats.jbossatx.jta.RecoveryManagerService;
import com.arjuna.ats.jta.recovery.XAResourceRecoveryHelper;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class NarayanaRecoveryManagerBean
implements InitializingBean,
DisposableBean {
    private final RecoveryManagerService recoveryManagerService;

    public NarayanaRecoveryManagerBean(RecoveryManagerService recoveryManagerService) {
        Assert.notNull(recoveryManagerService, "RecoveryManagerService must not be null");
        this.recoveryManagerService = recoveryManagerService;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        this.recoveryManagerService.create();
        this.recoveryManagerService.start();
    }

    @Override
    public void destroy() throws Exception {
        this.recoveryManagerService.stop();
        this.recoveryManagerService.destroy();
    }

    void registerXAResourceRecoveryHelper(XAResourceRecoveryHelper xaResourceRecoveryHelper) {
        this.getXARecoveryModule(RecoveryManager.manager()).addXAResourceRecoveryHelper(xaResourceRecoveryHelper);
    }

    private XARecoveryModule getXARecoveryModule(RecoveryManager recoveryManager) {
        for (RecoveryModule recoveryModule : recoveryManager.getModules()) {
            if (!(recoveryModule instanceof XARecoveryModule)) continue;
            return (XARecoveryModule)recoveryModule;
        }
        throw new IllegalStateException("XARecoveryModule is not registered with recovery manager");
    }
}

