/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.cache;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.springframework.boot.autoconfigure.cache.CacheType;
import org.springframework.boot.autoconfigure.cache.CaffeineCacheConfiguration;
import org.springframework.boot.autoconfigure.cache.CouchbaseCacheConfiguration;
import org.springframework.boot.autoconfigure.cache.EhCacheCacheConfiguration;
import org.springframework.boot.autoconfigure.cache.GenericCacheConfiguration;
import org.springframework.boot.autoconfigure.cache.GuavaCacheConfiguration;
import org.springframework.boot.autoconfigure.cache.HazelcastCacheConfiguration;
import org.springframework.boot.autoconfigure.cache.InfinispanCacheConfiguration;
import org.springframework.boot.autoconfigure.cache.JCacheCacheConfiguration;
import org.springframework.boot.autoconfigure.cache.NoOpCacheConfiguration;
import org.springframework.boot.autoconfigure.cache.RedisCacheConfiguration;
import org.springframework.boot.autoconfigure.cache.SimpleCacheConfiguration;
import org.springframework.util.Assert;

final class CacheConfigurations {
    private static final Map<CacheType, Class<?>> MAPPINGS;

    @Deprecated
    private static void addGuavaMapping(Map<CacheType, Class<?>> mappings) {
        mappings.put(CacheType.GUAVA, GuavaCacheConfiguration.class);
    }

    private CacheConfigurations() {
    }

    public static String getConfigurationClass(CacheType cacheType) {
        Class<?> configurationClass = MAPPINGS.get((Object)cacheType);
        Assert.state(configurationClass != null, "Unknown cache type " + (Object)((Object)cacheType));
        return configurationClass.getName();
    }

    public static CacheType getType(String configurationClassName) {
        for (Map.Entry<CacheType, Class<?>> entry : MAPPINGS.entrySet()) {
            if (!entry.getValue().getName().equals(configurationClassName)) continue;
            return entry.getKey();
        }
        throw new IllegalStateException("Unknown configuration class " + configurationClassName);
    }

    static {
        HashMap mappings = new HashMap();
        mappings.put(CacheType.GENERIC, GenericCacheConfiguration.class);
        mappings.put(CacheType.EHCACHE, EhCacheCacheConfiguration.class);
        mappings.put(CacheType.HAZELCAST, HazelcastCacheConfiguration.class);
        mappings.put(CacheType.INFINISPAN, InfinispanCacheConfiguration.class);
        mappings.put(CacheType.JCACHE, JCacheCacheConfiguration.class);
        mappings.put(CacheType.COUCHBASE, CouchbaseCacheConfiguration.class);
        mappings.put(CacheType.REDIS, RedisCacheConfiguration.class);
        mappings.put(CacheType.CAFFEINE, CaffeineCacheConfiguration.class);
        CacheConfigurations.addGuavaMapping(mappings);
        mappings.put(CacheType.SIMPLE, SimpleCacheConfiguration.class);
        mappings.put(CacheType.NONE, NoOpCacheConfiguration.class);
        MAPPINGS = Collections.unmodifiableMap(mappings);
    }
}

