/*
 * Decompiled with CFR 0.152.
 */
package com.juraszek.algorithm.io.parsers;

import com.juraszek.algorithm.io.parsers.Parser;
import com.juraszek.algorithm.utils.xmcda.XMCDAMessageParser;
import java.io.File;
import org.xmcda.ProgramExecutionResult;
import org.xmcda.XMCDA;
import org.xmcda.parsers.xml.xmcda_v3.XMCDAParser;

public class V3Parser
implements Parser {
    @Override
    public XMCDA loadXMCDA(String inputDirectory, ProgramExecutionResult executionResult) {
        XMCDA xmcda = new XMCDA();
        this.loadXMCDA(xmcda, new File(inputDirectory, "alternatives.xml"), false, executionResult, "alternatives");
        this.loadXMCDA(xmcda, new File(inputDirectory, "alternativesMatrix.xml"), true, executionResult, "alternativesMatrix");
        this.loadXMCDA(xmcda, new File(inputDirectory, "knownRankings.xml"), false, executionResult, "alternativesValues");
        this.loadXMCDA(xmcda, new File(inputDirectory, "parameters.xml"), true, executionResult, "programParameters");
        return xmcda;
    }

    private void loadXMCDA(XMCDA xmcda, File file, boolean mandatory, ProgramExecutionResult executionResults, String ... loadTags) {
        XMCDAParser parser = new XMCDAParser();
        String baseFilename = file.getName();
        if (!file.exists()) {
            if (mandatory) {
                executionResults.addError("Could not find the mandatory file " + baseFilename);
                return;
            }
            return;
        }
        try {
            parser.readXMCDA(xmcda, file, loadTags);
        }
        catch (Throwable throwable) {
            String msg = String.format("Unable to read & parse the file %s, reason: ", baseFilename);
            executionResults.addError(XMCDAMessageParser.getMessage(msg, throwable));
        }
    }
}

