/*
 * Decompiled with CFR 0.152.
 */
package com.juraszek.algorithm.heuristics.methods;

import com.juraszek.algorithm.heuristics.methods.HeuristicMethod;

public class MinimizingEstimationErrorMethod
implements HeuristicMethod {
    @Override
    public Double calculateConstant(Integer index, Double[][] M, Double[] C) {
        Double constantValue = 0.0;
        for (int i = 0; i < C.length; ++i) {
            if (C[i] == null) continue;
            constantValue = constantValue + M[index][i] * C[i];
        }
        Double matrixSize = M.length;
        constantValue = 1.0 / (matrixSize - 1.0) * constantValue;
        return constantValue;
    }

    @Override
    public Double calculateFactor(Integer i, Integer j, Double[][] M) {
        if (i.equals(j)) {
            return this.calculateSConstant(i, M) + 1.0;
        }
        Double matrixSize = M.length;
        return -((M[i][j] + M[j][i]) / (matrixSize - 1.0));
    }

    private Double calculateSConstant(Integer index, Double[][] M) {
        Double result = 0.0;
        for (int i = 0; i < M.length; ++i) {
            for (int j = 0; j < M.length; ++j) {
                if (j != index || i == index) continue;
                result = result + M[i][j] * M[i][j];
            }
        }
        result = 1.0 / ((double)M.length - 1.0) * result;
        return result;
    }
}

