/*
 * Decompiled with CFR 0.152.
 */
package com.juraszek.algorithm.heuristics.methods;

import com.juraszek.algorithm.heuristics.methods.HeuristicMethod;
import com.juraszek.algorithm.utils.HREResultConverter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class HeuristicMethodManager {
    @Autowired
    private HREResultConverter hreResultConverter;
    private HeuristicMethod method;

    public HeuristicMethod getMethod() {
        return this.method;
    }

    public void setMethod(HeuristicMethod method) {
        this.method = method;
    }

    public Double calculateError(Double[] results, Double[][] inputMatrix, Double[] C, Double[] prevC) {
        Double[] filledC = this.hreResultConverter.convertToResult(C, results);
        Double errorsSum = 0.0;
        for (int i = 0; i < C.length; ++i) {
            int counter = 0;
            for (int j = 0; j < C.length; ++j) {
                if (C[i] != null) continue;
                errorsSum = errorsSum + Math.abs(filledC[counter] - prevC[j] * inputMatrix[i][j]);
                ++counter;
            }
            errorsSum = 1.0 / (double)C.length * errorsSum;
        }
        return 1.0 / (double)results.length * errorsSum;
    }
}

