/*
 * Decompiled with CFR 0.152.
 */
package com.juraszek.algorithm.heuristics.methods;

import com.juraszek.algorithm.heuristics.methods.HeuristicMethod;

public class ArithmeticMethod
implements HeuristicMethod {
    @Override
    public Double calculateConstant(Integer index, Double[][] M, Double[] C) {
        Double constantValue = 0.0;
        for (int i = 0; i < C.length; ++i) {
            if (C[i] == null) continue;
            constantValue = constantValue + M[index][i] * C[i];
        }
        Double matrixSize = M.length;
        constantValue = 1.0 / (matrixSize - 1.0) * constantValue;
        return constantValue;
    }

    @Override
    public Double calculateFactor(Integer i, Integer j, Double[][] M) {
        if (i.equals(j)) {
            return 1.0;
        }
        Double factorValue = M[i][j];
        Double matrixSize = M.length;
        factorValue = -(1.0 / (matrixSize - 1.0)) * factorValue;
        return factorValue;
    }
}

