/*
 * Decompiled with CFR 0.152.
 */
package com.juraszek.algorithm.heuristics.jacobi;

import com.juraszek.algorithm.heuristics.methods.HeuristicMethodManager;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class JacobiParametersCreator {
    @Autowired
    private HeuristicMethodManager heuristicMethodManager;

    public Double[] generateVectorOfConstants(Double[][] M, Double[] C) {
        int vectorSize = this.calculateVectorSize(C);
        Double[] vectorOfConstants = new Double[vectorSize];
        Map<Integer, Integer> indexesMap = this.mapIndexesFromC(C);
        for (int i = 0; i < vectorSize; ++i) {
            vectorOfConstants[i] = this.heuristicMethodManager.getMethod().calculateConstant(indexesMap.get(i), M, C);
        }
        return vectorOfConstants;
    }

    public Double[][] generateMatrixOfFactors(Double[][] M, Double[] C) {
        int vectorSize = this.calculateVectorSize(C);
        Double[][] matrixOfFactors = new Double[vectorSize][vectorSize];
        Map<Integer, Integer> indexesMap = this.mapIndexesFromC(C);
        for (int i = 0; i < vectorSize; ++i) {
            for (int j = 0; j < vectorSize; ++j) {
                matrixOfFactors[i][j] = this.heuristicMethodManager.getMethod().calculateFactor(indexesMap.get(i), indexesMap.get(j), M);
            }
        }
        return matrixOfFactors;
    }

    private Map<Integer, Integer> mapIndexesFromC(Double[] c) {
        HashMap<Integer, Integer> indexesMap = new HashMap<Integer, Integer>();
        Integer mappedIndex = 0;
        for (int i = 0; i < c.length; ++i) {
            if (c[i] != null) continue;
            indexesMap.put(mappedIndex, i);
            Integer n = mappedIndex;
            Integer n2 = mappedIndex = Integer.valueOf(mappedIndex + 1);
        }
        return indexesMap;
    }

    private int calculateVectorSize(Double[] c) {
        return Math.toIntExact(Stream.of(c).filter(Objects::isNull).count());
    }
}

