/*
 * Decompiled with CFR 0.152.
 */
package com.juraszek.algorithm.heuristics;

import org.springframework.stereotype.Service;

@Service
public class ReciprocalMatrixConverter {
    public Double[][] convertToReciprocalMatrix(Double[][] pairsComparisons) {
        int dataSize = pairsComparisons.length;
        Double[][] reciprocalMatrix = new Double[dataSize][dataSize];
        for (int i = 0; i < dataSize; ++i) {
            for (int j = 0; j < dataSize; ++j) {
                reciprocalMatrix[i][j] = this.convertToReciprocal(pairsComparisons[i][j], pairsComparisons[j][i]);
            }
        }
        return reciprocalMatrix;
    }

    private Double convertToReciprocal(Double value, Double reciprocalValue) {
        if (value == null || reciprocalValue == null) {
            return value;
        }
        if (value * reciprocalValue != 1.0) {
            return Math.sqrt(value * (1.0 / reciprocalValue));
        }
        return value;
    }
}

